function Model = PreProcess(Model,Flag)
GuiNames

if isa(Model,'struct')
   cbf  = 'PreProcess(NaN);';
   h    = CenWindow(WIC,'Preprocess',cbf,435,300);
   set(h,'toolbar','none')
   Base = -55;
   ScaleMeth = {'None','St. dev','RMS','Frobenius'};
   if Flag == 1
      Base = 10;
      uicontrol(ty,fr,pos,[ 7   7 283 56],bg,FRC)
      uicontrol(ty,tx,pos,[10  35 270 25],st,'Y',ha,'center',ari{:},fs,14,bd{:},bg,FRC)
      uicontrol(ty,ch,pos,[15  10 130 25],st,'Centre Batches',cb,cbf,tg,'CenY',ha,'center',ari{:},bg,FRC,ud,1,va,Model.sam(1).cen(2))
      uicontrol(ty,pu,pos,[155 11 130 25],st,ScaleMeth,cb,cbf,tg,'ScalY',      ha,'center',ari{:},bg,'w',ud,1,va,Model.var(2).scal(1) + 1);
   elseif Flag == 2
      FrH  = length(Model.var(2).cen)* 25 + 81;
      Base = length(Model.var(2).cen)* 25 + 10;
      uicontrol(ty,fr,pos,[ 7   7 283 FrH],bg,FRC)
      uicontrol(ty,ch,pos,[ 15 Base     130  25],st,'Batches',cb,cbf,tg,'CenY2',ari{:},bg,FRC,va,Model.sam(1).cen(1),ud,1)
      uicontrol(ty,pu,pos,[155 Base + 1 130  25],st,ScaleMeth,cb,cbf,tg,'ScalY2',ari{:},bg,'w',va,Model.sam(1).scal(1)+1,ud,1);
      for i = 1:length(Model.var(2).cen)
         uicontrol(ty,ch,pos,[15  Base - 25 * i     130 25],st,Model.var(1).sel{i}.name.or,cb,cbf,tg,'CenY2', ari{:},bg,FRC,va,Model.var(1).cen(i),ud,i + 1)
         uicontrol(ty,pu,pos,[155 Base + 1 - 25 * i 130 25],st,ScaleMeth,                  cb,cbf,tg,'ScalY2',ari{:},bg,'w',va,Model.var(1).scal(i) + 1,ud,i + 1);
      end
      uicontrol(ty,tx,pos,[10  Base + 50 270 25],st,'Y',ha,'center',ari{:},bd{:},fs,14,bg,FRC)
      uicontrol(ty,tx,pos,[10  Base + 25 130 25],st,'Centre',ha,'center',ari{:},bd{:},fs,12,bg,FRC)
      uicontrol(ty,tx,pos,[155 Base + 25 130 25],st,'Scale',ha,'center',ari{:},bd{:},fs,12,bg,FRC)
      Base = length(Model.var(2).cen)* 25 + 30 ;
   end
   FrY  = Base + 62;
   Base = length(Model.var(1).cen)* 25 + Base + 65;
   FrH  = 25 * (length(Model.var(1).cen) + 1) + 56; 
   uicontrol(ty,fr,pos,[  7 FrY  283 FrH],bg,FRC)
   uicontrol(ty,ch,pos,[ 15 Base     130  25],st,'Batches',cb,cbf,tg,'CenX',ari{:},bg,FRC,va,Model.sam(1).cen(1),ud,1)
   uicontrol(ty,pu,pos,[155 Base + 1 130  25],st,ScaleMeth,cb,cbf,tg,'ScalX',ari{:},bg,'w',va,Model.sam(1).scal(1)+1,ud,1);
   for i = 1:length(Model.var(1).cen)
      uicontrol(ty,ch,pos,[15  Base - 25 * i     130 25],st,Model.var(1).sel{i}.name.or,cb,cbf,tg,'CenX', ari{:},bg,FRC,va,Model.var(1).cen(i),ud,i + 1)
      uicontrol(ty,pu,pos,[155 Base + 1 - 25 * i 130 25],st,ScaleMeth,              cb,cbf,tg,'ScalX',ari{:},bg,'w',va,Model.var(1).scal(i) + 1,ud,i + 1);
   end
   uicontrol(ty,tx,pos,[10  Base + 50 270 25],st,'X',ha,'center',ari{:},bd{:},fs,14,bg,FRC)
   uicontrol(ty,tx,pos,[10  Base + 25 130 25],st,'Centre',ha,'center',ari{:},bd{:},fs,12,bg,FRC)
   uicontrol(ty,tx,pos,[155 Base + 25 130 25],st,'Scale',ha,'center',ari{:},bd{:},fs,12,bg,FRC)
   uicontrol(ty,ps,pos,[295        10 130 30],st,'Ok',cb,cbf,tg,'Ok',ari{:})
   uicontrol(ty,ps,pos,[295        46 130 30],st,'Cancel',cb,cbf,tg,'window',ari{:})
   Pos = get(h,pos);
   set(h,pos,[Pos(1:2) 435 FrY + FrH + 7])
   setcvdata(h,'Model',Model);
   waitfor(h,'waitstatus','close')
   Model = getcvdata(h,'Model');
   delete(h)
   return
else
   Model = getcvdata(gcbf,'Model');
   switch ctag
   case 'Ok'
      set(gcbf,'waitstatus','close')
      
   case 'window'
      setcvdata(gcbf,'Model',[])
      set(gcbf,'waitstatus','close')
      
   case 'CenX'
      if get(gcbo,ud) == 1
         Model.sam(1).cen(1) = cval;
      else
         Model.var(1).cen(get(gcbo,ud)-1) = cval;
      end
      
   case 'CenY'
      Model.sam(1).cen(2) = cval;
      
   case 'CenY2'
      if get(gcbo,ud) == 1
         Model.sam(1).cen(2) = cval;
      else
         Model.var(2).cen(get(gcbo,ud)-1) = cval;
      end
      Model.sam(1).cen(2) = cval;
      
   case 'ScalX'
      a = get(gcbo,ud);
      if a(1) == 1
         Model.sam(1).scal(1) = cval - 1;
      else
         Model.var(1).scal(get(gcbo,ud)-1) = cval - 1;
      end
      
   case 'ScalY'
      a = get(gcbo,ud);
      Model.var(2).scal(1) = cval - 1;
      Model.sam(1).scal(2) = 0;
      
   case 'ScalY2'
      a = get(gcbo,ud);
      if a(1) == 1
         Model.sam(1).scal(2) = cval - 1;
      else
         Model.var(2).scal(get(gcbo,ud)-1) = cval - 1;
      end
      
   end
   setcvdata(gcbf,'Model',Model);
   
end