function PlotValidation(x,y,z,PlotStruct,Labels,Axes)
% function PlotValidation (x,y,z,PlotStruct,Labels,Axes);
% 
% Description:
% Plot data according to the specifications in PlotStruct relative to the validation part.
% 
% Inputs: 
% x, y, z: vectors or matrices of compatible size defining the coordinates.
% PlotStruct: PlotStruct data structure
% Labels: Label object relative to the mode specified in PlotStruct.nummode
% Axes: handle of the axes where the plot is drawn.
% Outputs:
% None
% 
% Called by:
% None
% 
% Subroutines:
% Internal:None
% External: plotconvex, plotlabels
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 19-Aug-2002 19:16:08
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

if isempty(z)
   z = x * 0;
end
if any(all(isnan(x),2) | all(isnan(y),2) | all(isnan(z),2)) & strcmp(PlotStruct.marker,'poly')
   PlotStruct.marker = '.';
end
if strcmp(PlotStruct.marker,'poly')
   Handle_Plot = PlotConvex(x,y,z);
   if ~isempty(PlotStruct.color)
      set(findobj(Handle_Plot,'type','patch'),'facecolor',PlotStruct.color)
      %set(findobj(HandlePlot,'type','line'),'color',PlotStruct.color,'linestyle',PlotStruct.linestyle)
   end
else
   if ~isempty(PlotStruct.color)
      Handle_Plot = plot3(x,y,z);
      set(Handle_Plot,'color',PlotStruct.color)
   else
      Handle_Plot = plot3(x,y,z,'b');
   end
end
if PlotStruct.format(1) == 1
   %Number
   Handle_Labels = PlotLabels(x,y,z,Labels.scalars,PlotStruct.color);
   set(Handle_Plot,'linestyle','none','marker','none')
elseif PlotStruct.format(1) == 2
   %Label
   Handle_Labels = PlotLabels(x,y,z,Labels.labels,PlotStruct.color);
   set(Handle_Plot,'linestyle','none','marker','none')
elseif PlotStruct.format(1) == 3
   if isempty(PlotStruct.marker)
      set(Handle_Plot,'marker','none')
   else
      if ~strcmp(PlotStruct.marker,'poly')
         set(Handle_Plot,'marker',PlotStruct.marker)
      end
   end      
elseif PlotStruct.format(1) == 4
   set(Handle_Plot,'marker','none')
   Handle_Labels = [];
end
if PlotStruct.format(2) == 1
   if ~strcmp(PlotStruct.marker,'poly')
      set(Handle_Plot,'linestyle',PlotStruct.linestyle)
   else
      set(gca,'nextplot','add')
      if ~isempty(PlotStruct.color)
         Handle_Plot = plot3(x,y,z);
         set(Handle_Plot,'color',PlotStruct.color)
      else
         Handle_Plot = plot3(x,y,z,'b');
      end
   end
else
   set(Handle_Plot,'linestyle','none')
end
if PlotStruct.plotdims < 3
   view(2)
else
   view(3)
end

