function PlotTargetLine(Slope)
% function PlotTargetLine (Slope);
% 
% Description:
% Plot a "diagonal" green line on the current axes. If not otherwise specified the line has slope 1 and intercept 0.
% 
% Inputs: 
% Slope (optional): [slope,intercept] of the line to be plot. The default is [1 0];
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% Various Model_nPLS1\Plot_* and Model_PARAFAC\Plot_*
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 13-Aug-2002 13:30:02
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 

Ax   = gca;
XLim = get(gca,'xlim');
YLim = get(gca,'ylim');
Min  = min([XLim(1),YLim(1)]);
Max  = max([XLim(2),YLim(2)]);
hold on
if nargin
   y = [Min,1;Max,1]*Slope;
else
   y = [Min,Max];
end
plot([Min,Max],y,'-g');
set(gca,'xlim',XLim)
set(gca,'ylim',YLim)
hold off
