function PlotModel(x,y,z,PlotStruct,Labels,Axes)
% function PlotModel (x,y,z,PlotStruct,Labels,Axes);
% 
% Description:
% Plot data according to the specifications in PlotStruct relative to the model.
% 
% Inputs: 
% x, y, z   : vectors or matrices of compatible size defining the coordinates.
% PlotStruct: PlotStruct data structure
% Labels    : Label object relative to the mode specified in PlotStruct.nummode
% Axes      : handle of the axes where the plot is drawn.
% 
% Outputs:
% None
% 
% 
% Called by:
% None
% 
% Subroutines:
% Internal: None
% External: plotlabels
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 08-Oct-2002 15:40:38
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 
if isempty(z)
   z = x * 0;
end
set(Axes,'nextplot','add')
Handle_Labels = [];
Handle_Plot   = [];
if ~isempty(PlotStruct.color)
   Handle_Plot = plot3(x,y,z);
   set(Handle_Plot,'color',PlotStruct.color)
else
   Handle_Plot = plot3(x,y,z);
end
set(Handle_Plot,'marker','none','tag','model')
switch PlotStruct.visible
case 'on'
   if PlotStruct.format(1) == 1
      %Number
      Handle_Labels = PlotLabels(x,y,z,Labels.scalars,PlotStruct.color);
      set(Handle_Plot,'marker','none','tag','model')
   elseif PlotStruct.format(1) == 2 | (PlotStruct.format(1) == 3 & strcmp(PlotStruct.marker,'poly'))
      %Label
      Handle_Labels = PlotLabels(x,y,z,Labels.labels,PlotStruct.color);
      set(Handle_Plot,'marker','none','tag','model')
   elseif (PlotStruct.format(1) == 3 & ~strcmp(PlotStruct.marker,'poly')) | PlotStruct.format(1) == 4
      if isempty(PlotStruct.marker)
         set(Handle_Plot,'marker','.','tag','model')
      else
         set(Handle_Plot,'marker',PlotStruct.marker,'tag','model')
      end
   else
      Handle_Labels = [];
   end
case 'label'
   Handle_Labels = PlotLabels(x,y,z,Labels.labels,PlotStruct.color);
   set(Handle_Plot,'marker','none')

case 'marker'
   if strcmp(PlotStruct.marker,'poly') | isempty(PlotStruct.marker)
      set(Handle_Plot,'marker','.','tag','model')
   else
      set(Handle_Plot,'marker',PlotStruct.marker,'tag','model')
   end
   
case 'number'
   %Number
   Handle_Labels = PlotLabels(x,y,z,Labels.scalars,PlotStruct.color);
   set(Handle_Plot,'marker','none')
end
if PlotStruct.format(2) == 1
   set(Handle_Plot,'linestyle',PlotStruct.linestyle)
else
   set(Handle_Plot,'linestyle','none','tag','model')
end
if PlotStruct.additional.validation
   if ~strcmp(PlotStruct.color,'k') | isempty(PlotStruct.color)
      set(Handle_Labels,'color','k');
      set(Handle_Plot,'color','k');
   else
      set(Handle_Labels,'color','r');
      set(Handle_Plot,'color','r');
   end
end
if PlotStruct.plotdims < 3
   view(2)
else
   view(3)
end

