function Handle = PlotLabels(X,Y,Z,Label,Colour)
% function Handles = PlotLabels (X,Y,Z,Label,Colour);
% 
% Description:
% Insert description here 'Color code: marroon' 
% 
% Inputs: 
% X, Y, Z: vectors or matrices of compatible size defining the coordinates for the labels.
% Label  : cell vector of chars or vector of doubles
% Colour : colour for the labels to be plot. The standard MatLab values for this property are accepted.
% 
% 
% Outputs:
% Handles: vector of handles to the plotted labels
% 
% 
% Called by:
% PlotModel, PlotValidation
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 13-Aug-2002 09:50:30
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%

if isempty(Z)
   Z = 0 * X;
end
if isa(Label,'double')
   Labs = num2str(Label);
elseif isa(Label,'cell')
   Labs = char(Label);
else
   return
end
if size(X,2) > 1 | size(Y,2) > 1 | size(Z,2) > 1 
   V = max([size(X,2), size(Y,2), size(Z,2)]);
   X = X(:);
   Y = Y(:);
   Z = Z(:);
   M = max([length(X),length(Y),length(Z)]);
   S = M/V;
   X = repmat(X,M/length(X),1);
   Y = repmat(Y,M/length(Y),1);
   Z = repmat(Z,M/length(Z),1);
   Labs = repmat(Labs,V,1);
else
   [S,V] = size(X);
end
if isempty(Colour)
   
   Handle = [];
   Col = [ 0         0    1.0000
      0    0.5000         0
      1.0000         0         0
      0    0.7500    0.7500
      0.7500         0    0.7500
      0.7500    0.7500         0
      0.2500    0.2500    0.2500];
   Colour = [repmat(Col,floor(V/7),1);Col(1:rem(V,7),:)];
   for i = 1:V
      
      pf     = text(X((i - 1) * S + 1:i * S,:),...
         Y((i - 1) * S + 1:i * S,:),...
         Z((i - 1) * S + 1:i * S,:),...
         Labs((i - 1) * S + 1:i * S,:),...
         'fontsize',7,'fontname','Arial',...
         'color',Colour(i,:),...
         'tag','plot_label',...
         'horizontalalignment','center',...
         'verticalalignment','middle');
      Handle = [Handle;pf(:)];
      
   end 
   
else
   
   Handle = text(X,Y,Z,Labs,...
      'fontsize',7,'fontname','Arial',...
      'color',Colour,...
      'tag','plot_label',...
      'horizontalalignment','center',...
      'verticalalignment','middle');
   
end
