function p = PlotConvex(X,Y,Z)
% function Handles = PlotConvex (X,Y,Z);
% 
% Description:
% Plot the rows of X, Y, Z as convex hulls. If Z is not empty the hulls are tridimensional.
% In other words: the first rows of X, Y and Z are used to plot th first hull, 
% the second rows for the second hull and so forth.
% NaNs are automatically skipped.
% 
% Inputs: 
% X: x coordinates of the points
% Y: y coordinates of the points
% Z: z coordinates of the points
% 
% Outputs:
% Handles: vector of handles to the single convex hulls.
% 
% Called by:
% PlotValidation
% 
% Subroutines:
% Internal:None
% External: None
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 22-Aug-2002 00:08:04
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
%
if nargin < 3
   Z = 0;
end
if all(Z(~isnan(Z(:))) == 0) 
Colours = [0         0    1.0000
         0    0.5000         0
    1.0000         0         0
         0    0.7500    0.7500
    0.7500         0    0.7500
    0.7500    0.7500         0
    0.2500    0.2500    0.2500];
 for i = 1:size(X,1)
      a    = X(i,~isnan(X(i,:)));
      b    = Y(i,~isnan(Y(i,:)));
      k    = convhull(a,b);
      p(i) = fill(a(k),b(k),Colours(rem(i-1,size(Colours,1))+1,:));
      set(gca,'nextplot','add')
   end
else
   for i=1:size(X,1);
      a    = X(i,~isnan(X(i,:)))';
      b    = Y(i,~isnan(Y(i,:)))';
      c    = Z(i,~isnan(Z(i,:)))';
      k    = convhulln([a,b,c]);
      p(i) = trisurf(k,a,b,c);
      set(gca,'nextplot','add')
   end
end

