function varargout = FacPerm(Perm,varargin)
% function [ap,bp,cp,...] = FacPerm (Perm,a,b,c,...);
% 
% Description:
% Permute factors of a, b, c, ... according to Perm
% 
% Inputs: 
% Perm: permutation matrix.
% a,b,c,...: loading matrices to be permuted.
% 
% Outputs:
% ap,bp,cp,...: permuted loading matrices
% 
% 
% Called by:
% ValidateModel, ModelPARAFAC\Compute_Risk
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 30-Jan-2002 14:12:54
%

for i=1:nargin-1
   varargout{i} = varargin{i} * Perm;
end
