function DispInfo(h)
% function DispInfo(Handle);
% 
% Description:
% Displays the 'tag' of an object upon clicking (i.e. it is used as a 'ButtonDownFcn' for some plots).
% The tag remains visible on the plot for 1.5 sec.
% 
% Inputs: 
% Handle: handle of the object whose tag is to be displayed.
% 
% Outputs:
% None
% 
% Called by:
% Model_PARAFAC/Plot_Partial_RSS, Model_nPLS1/Plot_Partial_RSS
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 11-Oct-2002 18:37:26
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 
s = get(h,'tag');
a = get(gcf,'units');
set(gcf,'units','points')
t = get(gcf,'currentpoint');
set(gcf,'units',a)
a = axes('units','points','position',[t,50,10],'box','on','xtick',[],'ytick',[]);
b = text(.51,.5,s,'verticalalignment','middle','horizontalalignment','center','fontsize',9);
u = get(b,'units');
set(b,'units','points')
c = get(b,'extent');
set(b,'units',u);
set(a,'position',[t,c(3) * 1.05 c(4) * 1.01])
pause(1.5)
delete(a)
