function [ModelOut,PlotStr] = DefModelOut
% function [ModelOut,PlotStr] = DefineModelOut;
% 
% Description:
% Initialise (as empty or as default values when necessary) the ModelOut and PlotStruct data structures.
 % 
% 
% Inputs: 
% None
% 
% 
% Outputs:
% ModelOut: "empty" ModelOut structure
% PlotStr: "empty" PlotStruct structure 
 % 
% 
% Called by:
% FitModel, ImportData, Load_ExtData, ValidateModel, Model_nPLS1\Calculate, Model_PARAFAC\Calculate
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 04-Nov-2002 16:51:18
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
% 
PrePr    = struct('cen',[],'scal',[]);
Stat     = struct('dcon',{{}},...             %D-statistic contribution (only offline)
                  'dconlim',{{}},...          %D-statistic contribution limits(only offline)
                  'dlim_off',[],...           %D-statistic limits off line
                  'dlim_on',[],...            %D-statistic limits on line
                  'd_off',[],...              %D-statistic off line
                  'd_on',[],...               %D-statistic on line
                  'elllim',[],...             %Hotelling ?
                  'expvar',{{}},...           % explained variation for each modality of each mode
                  'hotelling',{{}},...        % Hotelling statistic of each modality of each mode
                  'mse',[],...                % Mean Squared Error for the different factors
                  'quality',{{}},...          % angle between original modality and its projection
                  'q_on',[],...               %Q-statistic on
                  'qlim_on',[],...            %Q-statistic limits on line
                  'risk',[],...               %Risk function for the resampling methods
                  's',[],...                  %Scores covariance matrix/array
                  'scores',[],...             %Scores after filling in
                  'sinv',[],...               %Inverse of the variance/covariance matrix
                  'spe',[],...                %Squared prediction error (only on line)
                  'spelim',[],...             %Squared prediction error limits
                  'std',{{}});                %Standard deviation for parameters in the different modes

info     = struct('areaopt',[],...    %
                  'content',[],...    % Content structure of the original array without unfolding (used in PARAFAC and nPLS)
                  'direction',[],...  %
                  'fillin',[],...     % Filling in when statistics are applied in an online mode
                  'H',[],...          %
                  'objsel',[],...     %
                  'ropt',[],...       %
                  'rtopt',[],...      %
                  'sdopt',[]);        %
                  
Mod      = struct('bcoeff',[],...      %Regression coefficients
   'core',[],...                       %Tucker, nPLS core array
   'hotelling',[],...                  %Not necessary and to be included in stats, I think
   'iterations',[],...                 %Number of iterations
   'nbfactors',[],...                  %Number of factors
   'stats',Stat,...
   'xcumpress',[],...                  %Cumulated residual sum of squares for the prediction (calibration) for X
   'xev',[],...                        %Explained variance/variation for X
   'xfactors',{{}},...                 %Model factors for X
   'xpred',[],...                      %Predictions (calibration) for X
   'xpreproc',PrePr,...                %Preprocessing for X
   'xpress',[],...                     %
   'xrmse',[],...                      %Root Mean Squared Error for X
   'ycumpress',[],...                  %Cumulated residual sum of squares for the prediction (calibration) for Y
   'yev',[],...                        %Explained variance/variation for Y
   'yfactors',{{}},...                 %Model factors for X
   'ypred',[],...                      %Predictions (calibration) for Y
   'ypreproc',PrePr,...                %Preprocessing for X
   'ypress',[],...                     %Not in use (remove?)
   'yrmse',[]);                        %Root Mean Squared Error for X
Pred     = struct('core',[],...                       
   'data',[],...                       %copy of external data, as cbdataset, to preserve labels, scalars etc
   'nbfactors',[],...                  %number of factors used to compute the model
   'stats',Stat,...                  
   'xcumpress',[],...
   'xev',[],...
   'xfactors',{{}},...                 
   'xpred',[],...
   'xpress',[],...
   'xrmse',[],...
   'yfactors',{{}},...                  
   'ypred',[]);                        
PlotStr  = struct('additional',struct('batch',[],...                     %duplicated
                                      'batchyn',0,...                    %duplicated
                                      'bootstrap',[],...                 %
                                      'hotelling',struct('exist',0,...   %Variables of hotelling ellipsoid on the plot
                                                         'confid',[80 90],...  % default levels of condidence region
                                                         'num',0,...     %
                                                         'plot',1,...    %
                                                         'size',100),... % size to trace ellipsoiid
                                      'plotvi',[1 1 1],...               %
                                      'potential',struct('exist',0,...   %Variables of potential functions
                                                         'liss',0.1,...  % lissage constant
                                                         'num',0,...     %
                                                         'plot',1,...    % kinf of plot:contour, contourf, etc..
                                                         'size',100),... % size 
                                      'quality',struct('exist',0,...     %
                                                       'limqual',0.9),...%
                                      'shadow',0,...                     %
                                      'state',0,...                      %
                                      'type2','',...                     %'X' or 'Y'
                                      'validation',[]),...               %0:2 show/don't show validation and different possibilities (i.e. predictions or replicates in leave one out)
                  'batch',[],...                     %duplicated
                  'batchyn',0,...                    %duplicated
                  'color','r',...        %Either the letter or a three values double vector with the RGB components
                  'factors',[1 2 3],...  %Component/Factor/LV for the three possible axes
                  'format',[2 1],...     %Possible values: (1)  1:4 (1: number, 2: label 3: marker 4: no-marker)
                  ...                    %                 (2)  1:2 discrete/continuous
                  'grid','on',...        %grid 'on'/'off'
                  'linestyle','-',...    %Possible values: All the possible linestyles
                  'marker','.',...       %Possible values: All the possible markers
                  'nummode',1,...        %number of the selected mode for plots :CAUTION!can be a vector for mixed modes in tucker and tuckervi
                  'plotdims',2,...       %1D plot, 2D plots, 3D
                  'type','',...          %Type of plot. E.g. 'Loadings','Explained_Variance', etc
                  'visible','on');       %Model visible or not in the plot (in PARAFAC and nPLS/PLS)
                                         %Possible values: 'on'/'off' 
                                         %in PARAFAC and nPLS/PLS also: 'label' the model is plot using labels overimposed to validation (if that is also plotted)
                                         %                              'marker' the model is plot using markers overimposed to validation (if that is also plotted)
                                         %                              'number' the model is plot using numbers overimposed to validation (if that is also plotted)
Val      = struct('bcoeff',[],...        %Same as in Model: if a resampling validation method (loo,nboo,rboo) are used one dimension is added for the different realisations
   'core',[],...                         %Same as in Model: if a resampling validation method (loo,nboo,rboo) are used one dimension is added for the different realisations
   'iterations',[],...                   %Number of iterations
   'method',[],...                       %Validation method: nboo - naive booststrapping
    ...                                  %                   rboo - residuals booststrapping
    ...                                  %                   loo  - leave one out
    ...                                  %                   test - test set
    ...                                  
   'nbfactors',[],...                    %no longer necessary
   'prediction',Pred,...                 % sorry but i need this structure for bootstrap predictions...  CD (12/12/2002)
   'segments',[],...                     %matrix with the composition of the different segments row = samples; columns = replicate (i.e. the samples included in each replicate)
   'stats',Stat,...                      %
   'xcumpress',[],...                    %filled with 'loo' and 'test'
   'xev',[],...                          %filled with 'loo' and 'test'
   'xfactors',{{}},...                   %Same as in Model: if a resampling validation method (loo,nboo,rboo) are used one dimension is added for the different realisations
    ...                                  %For loo, the last slab in the first loading matrix includes the scores obtained by prediction when the corresponding sample is left out
   'xpred',[],...                        %Available for 'loo' and 'test'
   'xpress',[],...
   'xrmse',[],...
   'ycumpress',[],...
   'yev',[],...
   'yfactors',{{}},...                   %Same as for 'xfactors'
   'ypred',[],...
   'ypress',[],...
   'yrmse',[]);
ModelOut = struct('model',Mod,...
   'modelname',[],...
   'validation',Val,...
   'data',struct('batches',[],...
                 'dataset',[],...
                 'variables',[]),...
   'info',info,...
   'prediction',Pred,...
   'plot',PlotStr);

