function [Data,Con,Sams,Vars] = DefineArray(Model,XorY,CalorTest,Flag)
% function [Data,Con,Sams] = DefineArray (Model,XorY,CalorTest,Flag);
% 
% Description:
% It extracts the subset according to the selection of both samples/batches and variables stored
% in the ModelIn structure (in sam and var, respectively). 
% 
% Inputs: 
% Model    : ModelIn structure
% XorY     : it is the index within the X data structure. 
%            If 1, Data refers to X{1}, if 2, to X{2} (i.e. Y).
%            The need to specify within this function is a relish of an old syntax, 
%            currently one variable is assigned either to X or to Y if it belongs to X{1} or X{2} 
%            respectively.This ambiguity will likely be removed in the next revision of this file.
% CalorTest: it can assume values 1, 2, or 0; Data will then contain the samples/batches assigned 
%            respectively to the calibration set,to the test set or to both.
% Flag     : determines the class of the elements of Data (i.e. cbdataset or double/cell)
% 
% 
% Outputs:
% Data: is a cell vector length 1 or 2 (obsolete ambiguity that will be removed in the next release). 
%       If Flag is 1, Data is a cell array of cbdataset objects (either of type: 'Data' or 'Batch',
%       depending on the type of the sets stored in the X data structure). 
%       If Flag is 0, Data is an n-way array for 'single set' - i.e. of type 'Data' - data sets and
%       a cell vector for 'multiple set' - i.e. of type 'Batch' - data sets (to account for possibly 
%       different lengths).
% Con : cell vector of length 1 or 2 with the Content objects relative to the selection.
% Sams: position of the samples/batches in the X data structure.
% Vars: cell vector where each element refers to a mode of the selected array 
%       (either X or Y, with the same ambiguity as before). Each element contains the selected 
%       variables in the original array in the corresponding mode.
% 
% 
% Called by:
% Model_nPLS1\Calculate, Model_PARAFAC\Calculate, ExportData
% 
% Subroutines:
% Internal: none
% External: getcvdata
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 21-Oct-2002 07:49:04
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 
 
if nargin < 2
   XorY = 1;
end
if isempty(XorY)
   XorY = 1;
end
if nargin < 3
   CalorTest = 0;
end
if isempty(CalorTest)
   CalorTest = 0;
end
if nargin < 4
   Flag = 0;
end

X  = getcvdata(Model.xpointer,'X');
GL = [];
gr = [];
for i = 1:length(Model.sam)
   if ~CalorTest
      gr(i) = sum(Model.sam(i).sel.dims);
   else
      gr(i) = Model.sam(i).sel.dims(CalorTest);
   end
   GL{i} = Model.sam(i).sel.name;
end
if sum(gr > 0) > 1
   [sel,ok] = listdlg('uh',30,'Liststring',GL,'PromptString',{'Select the group of samples','',''},'SelectionMode','single');
   if ok
      gr = gr(sel);
   else
      return
   end            
elseif length(gr) == 0
   return
end
if ~CalorTest
   Sams = Model.sam(i).sel.sel;
else
   Sams = Model.sam(i).sel.sel{CalorTest};
end
vr   = [];
Vars    = [];
for i = 1:length(Model.var)
   b = Model.var(i).sel.sel{XorY};
   if isa(b,'double')
      b = {b};
   end
   Vars{i}  = b;
   vr(i) = any(cellfun('length',Vars{i}));
end
vr = find(vr);
if isempty(vr)
   vr = 1:length(Model.var);
end
for i = vr
   for j = 1:length(Model.var(i).sel)
      if isempty(Vars{i}{j})
         Vars{i}{j} = 1:Model.var(i).dims(j);
      end
   end
   if Flag
      Data{i} = X{i}(Sams,Vars{i}{:});
      Con{i} = dscontent(Data{i});
      if strcmp(X{i}.type,'Batch')
         Sizes = cumsum(Data{i}.userdata);
         ExSiz = Data{i}.userdata;
         for j = 1:length(Sizes)
            ExSiz(j)               = sum(Sams <= Sizes(j));
            Sams(Sams <= Sizes(j)) = [];
         end
         ExSiz(~ExSiz) = [];
         Data{i}.userdata = ExSiz;
      end
   else
      if strcmp(X{i}.type,'Batch')
         Lengths = cumsum(X{i}.userdata);
         for j=1:length(X{i}.userdata)
            if any(Sams<=Lengths(j))
               Data{i}{j} = X{i}(Sams(Sams<=Lengths(j)),Vars{i}{:}).data;
               Con{i}{j}  = dscontent(X{i}(Sams(Sams<Lengths(j)),Vars{i}{:}));
               Sams(Sams<=Lengths(j)) = [];
            end
         end
         Data{i}(~cellfun('length',Data{i})) = [];
      else
         Data{i} = X{i}(Sams,Vars{i}{:}).data;
         Con{i}  = dscontent(X{i}(Sams,Vars{i}{:}));
      end
   end
end
Data(cellfun('length',Data) == 0) = [];
Con(cellfun('length',Con) == 0) = [];
