function Stats = DLims(Pred_Fun,Mode,Limit,Data,Model,Validation,ConfLim,FillIn,Segments,Stats,Cen,Scal)
% 
% Name: DLims.m
% Location: \CuBatch\Common\
% 
% function Stats = DLims(Pred_Fun,Mode,Limit,Data,Model,Validation,...
%                           ConfLim,FillIn,Segments,Stats,Cen,Scal) 
% 
% Description: 
% Computes the D-statistics, values, its limits, the contribution to the D-statistic of the different 
% variables in the various dimensions of the array and the relative confidence limits 
% (if a Leave One Out validation procedure was performed).
% Apart from the contributions (and their limits) the statistics can be computed both in an 'offline'
% and an 'online' mode.
% 
% NB This function will likely undergo some simplification of the syntax as many of the input %
%    parameters are contained in the same data structure. Beside it is not necessary to compute the 'online'
%    residuals every time the function is called.
% 
% Inputs: 
% Pred_Fun   : function computing the prediction for the desired model. 
%              It can be a string (for MatLab 5.3 or superior) or a function handle 
%              (for MatLab 6.x or superior)
%
% Mode       : 'on'/'off' =>  'online'/'offline'
%
% Limit      : 0/1 compute/do not compute D-statistics limits 
%              (based on Data for the D-statistics contributions) 
%
% Data       : array of doubles with the data used to compute the statistics
%
% Model      : model's parameters as required by Pred_Fun (i.e. as a structure ModelOut.model)
%
% Validation : model's parameters as determined throught the validation procedure (ModelOut.validation).
%              Currently only Leave One Out is supported for this purpose. 
%              It is necessary only for computing confidence limits for the D-statistics contributions.
%
% ConfLim    : confidence intervals (if empty or not given: 95% and 99%). 
%              NB. this parameter is somewhat superfluous and therefore will be eliminated 
%                  in future versions
%
% FillIn     : fill in method: 'cd'  current deviation, 'zero'  zeros, necessary only when Mode is 'on'
%
% Segments   : Validation segments (ModelOut.validation.segments). 
%              Necessary only for D-statistics contributions.
%              NB. this parameter is somewhat superfluous as already contained in Validation 
%                  and therefore will likely be eliminated in future versions
%
% StatsIn    : structure holding the statistics (if previously calculated)
%
% Cen,Scal   : preprocessing parameters as contained in Model.xpreproc. 
%              NB these parameters are somewhat superfluous as already contained in Model 
%                 and therefore will likely be eliminated in future versions
% 
% Outputs: 
% StatsOut: structure holding the various statistics relative to Data. With respect to StatsIn the fields relative to the D-statistics (with respect to Mode) are filled in. 
% 
% Called by:
% Plot_D_Statistics (nPLS1/PLS1), Plot_D_Statistics (PARAFAC)
% 
% Subroutines: 
% Internal:    none
% External:    OnLineRes, Pred_Fun
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 21 Oct. 2002 
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 
% References 
%

% Define limits and compute the corresponding statistics
switch lower(Mode)
case 'off' 
   if ~any(strcmp(fieldnames(Stats),'s')) | isempty(Stats.s) 
      Stats.s    = cov(squeeze(Model.xfactors{1}(:,:,end)));
      Stats.sinv = inv(Stats.s);
   end
   Stats.s    = squeeze(Stats.s(:,:,end));
   Stats.sinv = squeeze(Stats.sinv(:,:,end));
   T          = squeeze(Model.xfactors{1}(:,:,end));
   %D statistic
   Stats.d_off = diag(T * Stats.sinv * T');
   Stats.dcon  = {{}};
   for k = 2:ndims(Data)
      IndData = repmat({':'},ndims(Data),1);
      for i = 1:size(Data,k)
         IndData{k}       = i;
         Mod2             = Model;
         Mod2.xfactors{k} = Mod2.xfactors{k}(i,:);
         %D statistic contribution
         Pred             = feval(Pred_Fun,Data(IndData{:}),Mod2);
         if isa(Pred.xfactors,'cell')
            Stats.dcon{k}(:,i) = diag(T * Stats.sinv * Pred.xfactors{1}');
         else
            Stats.dcon{k}(:,i) = diag(T * Stats.sinv * Pred.xfactors');
         end
      end
   end
   if Limit
      I              = size(Model.xfactors{1},1);
      R              = size(Model.xfactors{1},2);
      Stats.dlim_off = finv(ConfLim(:),R,I - R) * R * (I^2 - 1) / I / (I - R);
%     for k = 2:ndims(Data)
%        if ~isempty(Validation) & size(Validation.xfactors{1},3) > size(Validation.xfactors{2},3)
%           Data    = nprocess(Data,~cellfun('isempty',Cen),~cellfun('isempty',Scal),Cen,Scal,1,-1);
%           %Only jack knife in this case
%           dcona   = [];
%           In      = repmat({':'},ndims(Data),1);
%           Factors = {};
%           for j = 1:size(Segments,2)
%              [IndA,IndB] = deal(In);
%              Mod2 = Validation;
%              for m = 1:ndims(Data) 
%                 Mod2.xfactors{m} = squeeze(Validation.xfactors{m}(:,:,j));
%              end
%              if ~isempty(Mod2.core)
%                 IndCore   = repmat({':'},ndims(Validation.core)-1,1);
%                 Mod2.core = squeeze(Validation.core(IndCore{:},j));
%              end
%              if ~isempty(Mod2.bcoeff)
%                 IndBCoeff   = repmat({':'},ndims(Validation.bcoeff)-1,1);
%                 Mod2.bcoeff = squeeze(Validation.bcoeff(IndBCoeff{:},j));
%              end
%              if ~isempty(Mod2.yfactors)
%                 for m = 1:length(Mod2.yfactors)
%                    Mod2.yfactors{m} = squeeze(Validation.yfactors{m}(:,:,j));
%                 end
%              end
%              Ta           = squeeze(Validation.xfactors{1}(Segments(:,j),:,j));
%              %not general it works only for jack knife
%              Tb           = squeeze(Validation.xfactors{1}(j,:,end));
%              %end of lack of generality
%              Sinv         = pinv(cov(Ta));
%              FicFac       = Mod2.xfactors{k};
%              for m = 1:size(Data,k)
%                 [IndA{[1,k]}]    = deal(j,m);
%                 Mod2.xfactors{k} = FicFac(m,:);
%                 Pred             = feval(Pred_Fun,Data(IndA{:}),Mod2);
%                 if isa(Pred.xfactors,'cell')
%                    dcona(j,m) = diag(Tb * Sinv * Pred.xfactors{1}');
%                 else
%                    dcona(j,m) = diag(Tb * Sinv * Pred.xfactors');
%                 end
%              end
%              Mod2.xfactors{k} = FicFac;
%           end
%           Std_Err = std(dcona,1) * sqrt(size(dcona,1)-1);
%           Av      = mean(Stats.dcon{k});
%        else
%           Std_Err = std(Stats.dcon{k},1);
%           Av      = mean(Stats.dcon{k});
%        end
%        Stats.dconlim{k} = [(Av + 2 * Std_Err)',(Av + 3 * Std_Err)'];
%     end
   end    
   
case 'on'
   [Nil,Nil,Nil,Nil,Stats.scores] = OnLineRes(Pred_Fun,Data,Model,FillIn,ConfLim,0,Cen,Scal);
   if ndims(Stats.s) < 3 & Limit
      for t = 1:size(Stats.scores,3) %Along the time dimension
         Stats.s(:,:,t)    = cov(squeeze(Stats.scores(:,:,t)));
         Stats.sinv(:,:,t) = inv(squeeze(Stats.s(:,:,t)));
      end 
   end
   for t = 1:size(Data,ndims(Data))
      T               = squeeze(Stats.scores(:,:,t));
      Stats.d_on(:,t) = diag(T * squeeze(Stats.sinv(:,:,t)) * T');
   end
   if Limit
      I             = size(Model.xfactors{1},1);
      R             = Model.nbfactors;
      Stats.dlim_on = finv(ConfLim(:),R,I - R) * R * (I^2 - 1) / I / (I - R);
   end
   
end