function CheckAxes(MainFig)
% function CheckAxes (MainFig);
% 
% Description:
% Resize the InfoBox (tag: 'CBInfoFrame') and the Results axes (marked with tag: 'cbaxes') 
% so that there are no overlappings and they fit the current size of CuBatch' main window 
% In its current implementation it works only when only one "Results axes" is displayed.
% 
% Inputs: 
% MainFig: CuBatch main window handle 
 % 
% 
% Outputs:
% None
% 
% 
% Called by:
% ResizeCuBatch, PARAFACPlot, nPLS1Plot
% 
% Subroutines:
% Internal: None
% External: None
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 21-Oct-2002 06:09:04
% 
% Contact: Giorgio Tomasi, gt@kvl.dk 
% 

%Get handles
Handle_Axes = findobj(MainFig,'type','axes','tag','cbaxes');
if length(Handle_Axes) == 1
   
   set(Handle_Axes,'units','normalized','position',[0.2464,0.0377,0.7312,0.9127])
   Prop        = get(Handle_Axes,{'xlabel';'ylabel';'zlabel';'title'});
   [Handle_XLabel,Handle_YLabel,Handle_ZLabel,Handle_Title] = deal(Prop{:});
   Handle_InfoFrame = findobj(MainFig,'type','axes','tag','CBInfoFrame');
   %Set units to pixels
   set([MainFig,Handle_Axes,Handle_InfoFrame,Handle_XLabel,Handle_YLabel,Handle_ZLabel,Handle_Title],'units','pixels')
   %Get object dimensions
   Dimensions1 = get([MainFig,Handle_Axes,Handle_InfoFrame]','position');
   Dimensions2 = get([Handle_XLabel,Handle_YLabel,Handle_ZLabel,Handle_Title]','extent');
   [Dims_Win,Dims_Axes,Dims_Info,Dims_XLabel,Dims_YLabel,Dims_ZLabel,Dims_Title] = deal(Dimensions1{:},Dimensions2{:});
   Rat = [1 1];
   %Check height
   Height = Dims_Title(2) + Dims_Title(4) - Dims_XLabel(2) + 20;
   %Correct height to make the axes fit the window
   if Height > Dims_Win(4)
      Rat(2) = Height/Dims_Win(4);
   end
   %Check Width
   Az_El = get(Handle_Axes,'view');
   if isequal(Az_El,[0 90])
      Dims_Vert = Dims_YLabel;
   else
      Dims_Vert = Dims_ZLabel;
   end
   Width = Dims_Win(3) - 30 - Dims_Axes(3) + Dims_Vert(1);
   if Width < Dims_Info(3)
      Rat(1) = (Dims_Axes(3) - Dims_Vert(1)) / (Dims_Win(3) - Dims_Info(3) - Dims_Info(1) - 30);
   end
   Dims_Axes(3:4) = Dims_Axes(3:4)./Rat;
   Dims_Axes(1)   = Dims_Info(3) + Dims_Info(1) - Dims_Vert(1) + 10;
   Dims_Axes(2)   = 10 - Dims_XLabel(2);
   set([Handle_XLabel,Handle_YLabel,Handle_Title],'units','normalized')
   if any(Rat ~= 1);
      set(Handle_Axes,'position',Dims_Axes)
   end
   if ~isempty(findobj(MainFig,'type','axes','tag','legend'))
      legend(findobj(MainFig,'type','axes','tag','legend'));
   end

end