function ActivatePlots(MainFig) 
% function ActivatePlots (MainFig);
% 
% Description:
% Activates the main windows menus depending on the loaded data.
% If a model has been loaded (i.e. ModelOut contains one), ActivatePlots calls the corresponding
% *ActivatePlots function, which takes care of the loaded Model's menus.
% 
% 
% Inputs: 
% MainFig: handle to the main window
% 
% 
% Outputs:
% None
% 
% 
% Called by:
% CuBatch
% 
% Subroutines:
% Internal: None
% External: getcvdata, guinames, *ActivatePlots
% 
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% MLI, LMT, Chemometrics group 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 05-Nov-2002 10:17:26
% 
% Contact: Giorgio Tomasi, gt@kvl.dk
%

GuiNames
[ModelIn,X,GlHan,ModelOut,OpMode] = getcvdata(MainFig,'Model','X','Handles','Results','Mode');
if isempty(ModelIn)
   X = [];
end
if ~isempty(X)
   %Activate submenus if X is available
   set([GlHan.edit GlHan.expl GlHan.permute GlHan.regress GlHan.sel GlHan.exp,GlHan.rep],en{:});
   %Activate X view submenus
   Nx = ndims(X{1});
   delete(allchild(GlHan.trajXview));
   delete(allchild(GlHan.landXview));
   set([GlHan.view,GlHan.landXview,GlHan.trajXview],en{:});
   if Nx > 3 | Nx == 1,
      set(GlHan.landXview,dis{:});
   end;
   for i=1:Nx,
      uimenu(GlHan.trajXview,la,['Mode ',int2str(i)],cb,'Cubatch(NaN)',tg,'ViewData');
      uimenu(GlHan.landXview,la,['Mode ',int2str(i)],cb,'Cubatch(NaN)',tg,'ViewData');
   end;
   if length(X) > 1
      %activate Y related menus: define labels, regression and view Y
      set([GlHan.yvars,GlHan.regress,GlHan.Yview],on{:})
      %activate Y view submenus
      Ny = ndims(X{2});
      delete(allchild(GlHan.trajYview));
      delete(allchild(GlHan.landYview));
      for i=1:Ny,
         uimenu(GlHan.trajYview,la,['Mode ',int2str(i)],cb,'Cubatch(NaN)',tg,'ViewData');
         uimenu(GlHan.landYview,la,['Mode ',int2str(i)],cb,'Cubatch(NaN)',tg,'ViewData');
      end;
      if Ny > 3 | Ny == 1,
         set(GlHan.landYview,dis{:});
      end;
   else
      %deactivate Y related menus: define labels, regression and view Y
      set([GlHan.yvars,GlHan.regress,GlHan.Yview],off{:})
   end
   %Redefine and activate edit->labels & info menu
   delete(allchild(GlHan.labels))
   for i = 1:min(length(ModelIn.var),2)
      uimenu(GlHan.labels,la,ModelIn.var(i).name,cb,'CuBatch(NaN)',tg,'EditLabels',ud,i)
   end
   if i
      set(GlHan.labels,on{:});
   end
   %Activate factor analysis and regression menus depending on the loaded data
   if ndims(X{1}) > 2
      set([GlHan.par GlHan.par2 GlHan.tuck GlHan.pca GlHan.npls GlHan.pls],en{:})
      set([GlHan.opa],dis{:});
      if ~strcmp(X{1}.type,'Data')
         set([GlHan.pls GlHan.npls GlHan.par],dis{:});
      end
   else
      set([GlHan.par GlHan.tuck GlHan.npls GlHan.pls],dis{:})
      set(GlHan.pca,en{:})
      if strcmp(X{1}.type,'Data')
         set([GlHan.opa3, GlHan.par2],dis{:})
         set([GlHan.opa GlHan.pls],en{:})
      else
         set([GlHan.opa ],dis{:})
         set([GlHan.opa3, GlHan.par2],en{:})
      end
   end
   if ~isempty(ModelIn)
      gr  = [0 0];
      for i = 1:length(ModelIn.sam)
         gr(i,:) = ModelIn.sam(i).sel.dims;
      end
      for i = 1:length(ModelIn.var)
         a{i}  = ModelIn.var(i).sel.sel{1};
         b{i}  = ModelIn.var(i).sel.sel{2};
         if ~isa(a{i},'cell')
            a{i} = {a{i}};
            b{i} = {b{i}};
         end
         vx(i) = any(cellfun('length',a{i}));
         vy(i) = any(cellfun('length',b{i}));
      end
      if ~any(gr(:,1)) | ~any(vx) 
         set([GlHan.expl,GlHan.regress],dis{:})
      else
         set([GlHan.expl,GlHan.regress],en{:})
      end
      if any(vy) 
         set(GlHan.regress,en{:})
      else
         set(GlHan.regress,dis{:})
      end   
   end
else
   set([GlHan.edit GlHan.expl GlHan.regress GlHan.sel GlHan.exp GlHan.rep],dis{:});
end
set(GlHan.useproj,cb,'CuBatch(NaN)')
delete(allchild(GlHan.useproj))
if ~isempty(ModelOut)
   %Activate menus depending on the loaded model
   if ~isempty(ModelOut(1).modelname)
      set([GlHan.view,GlHan.plot,GlHan.exppl,GlHan.predict,GlHan.win,GlHan.rep],en{:})
      switch ModelOut(1).modelname
         case 'PARAFAC'
            PARAFACActivatePlots(GlHan.plot,ModelOut)
            set(GlHan.usepred,dis{:})
            set([GlHan.useproj,GlHan.predict],en{:})
         case 'OPA'
            [ModelIn,ModelOut] = opaactivateplots(ModelIn,ModelOut,X);
            set(GlHan.usepred,dis{:})
            set([GlHan.useproj,GlHan.predict],en{:})
         case 'OPA3D'
            [ModelIn,ModelOut] = opa3activateplots(ModelIn,ModelOut,X);
            set(GlHan.usepred,dis{:})
            set([GlHan.useproj,GlHan.predict],en{:})
         case 'PARAFAC2'
            [ModelIn,ModelOut] = PARAFAC2ActivatePlots(ModelIn,ModelOut,X);
            set(GlHan.usepred,dis{:})
            set([GlHan.useproj,GlHan.predict],en{:})
         case 'PCA'
            AcpActivatePlots(ModelIn,ModelOut);
            set([GlHan.usepred,GlHan.predict],en{:})
            set(GlHan.useproj,en{:})
         case {'nPLS','PLS'}
            nPLS1ActivatePlots(GlHan.plot,GlHan.useproj,ModelOut)
            set(GlHan.useproj,en{:})
         case 'Tucker'
            TuckerActivatePlots(ModelIn,ModelOut);
            set([GlHan.usepred,GlHan.predict],en{:})
            set(GlHan.useproj,en{:})
         case 'IV-Tucker'
            TuckerviActivatePlots(ModelIn,ModelOut);
            set([GlHan.usepred,GlHan.predict],en{:})
            set(GlHan.useproj,en{:})
         case 'IV-PCA'
            AcpviActivatePlots(ModelIn,ModelOut);
            set([GlHan.usepred,GlHan.predict],en{:})
            set(GlHan.useproj,en{:})
      end
   else
      set([GlHan.plot,GlHan.exppl,GlHan.predict,GlHan.win],dis{:})
   end
else
   set([GlHan.view,GlHan.plot,GlHan.exppl,GlHan.predict,GlHan.win],dis{:})
end
if ~isequal(lower(OpMode),'advanced')
   set([GlHan.regress,GlHan.expl],off{:})
   set([GlHan.sel],dis{:})
end



