%ReadMeDataSet
% This README lists the procedures for updating the DataSet
% object and includes a running list of the release dates,
% version (e.g. for DataSet h: h.datasetversion), and comments
% on changes from previous versions.
%
%I) When updating the DATASET object:
%I.A) Version number (double) must be changed in:
% 1) constructor dataset.m
% 2) overloaded loadobj.m
%I.B) Version changes follow the convention:
%  for Version xx.yy
% 1) xx is incremented if object fields are changed or added
%   a) update DISPLAY, HELP, SUBSREF, SUBSASGN, CAT
% 2) yy is incremented if object methods are changed or added
%
%II) Update notes:
%Release Dates  Version  Comments
%  11-08-02       3.02    updated manual, this document, and constructor/loader
%                         CAT fixed bugs when concatenating with different numbers of sets,
%                           allowed cat in dim > ndim (e.g. cat of slabs), history field note 
%                           of cat operation, allow cat of datasets and non-datasets, use name 
%                           and author from all datasets.
%   9-09-02               DELSAMPS make history notation for both soft AND hard deletions
%                           added "hard keep/reorder" option (flag==3)
%                         END method added to allow correct indexing into DataSet at top level
%                         SUBSASGN changed subscripting error message
%                         SUBSREF added object-level subscripting
%   8-30-02               DATASET added validclasses string, added empty dataset construction
%                         SIZE method added, gives size of .data field
%                         SUBSASGN removed extraneous tests of data class, revised error messages
%                           fixed various bugs associated with batch support
%                         SUBSREF allow extraction of all-modes and all-sets from fields (calls w/o vdim)
%                           revised error messages
%   5-21-02               LOADOBJ revised test logic to detect "same-fields but not same version #"
%                           added includ field orientation and test for includname presence
%                         SUBSASGN changed calls to sethistory and sethistory output format
%   4-16-02               SUBSASGN removed extraneous code in sethistory
%  11-06-01               CAT command added (generic concatenation), HORZCAT and VERTCAT now use CAT
%                         SUBSASGN allow empty assignment to axisscale and label fields

%  10-19-01        3.01   updated the manual, changed INCLUD, SET, GET, and data classes
%                         added SUBSASGN and SUBSREF
%   6-06-01               VERTCAT fixed bug when combining two datasets with different # of includ sets
%   6-05-01               SUBSASGN fixed includ size bug (adding data to empty dataset created
%                         includ field with only 1 column)
%   5-31-01               GET revised as call to DATASET/SUBSREF
%                         SET revised as call to DATASET/SUBSASGN (centralized code)
%                         SUBSASGN added subscripting into fields for assignment
%                         fixed bug which kept batch data axisscales from being addressed correctly
%                         fixed bugs in data assign checking batch data size
%                         SUBSREF added subscripting into ALL fields
%   5-30-01               DELSAMPS added transposition of row-vector batch cell to column-vector
%   5-14-01               DELSAMPS added "hard delete" flag==2
%   5-11-01               DELSAMPS terminated line 67 x.includ{vdim} = setdiff(x.includ{vdim},inds) with ;
%                         added b.includ = cell(nmodes,2); (this is different from the
%                         previous version which used b.includ = cell(ndims) which didn't
%                         follow the convention of different modes on different rows
%                         DISPLAY improved include display, and fixed size bug for cells (lablel, etc.)
%                         VERTCAT adapted for use with ingle, uint8, etc.
%                         removed use of SET and GET
%                         changed to allow class sets in mode 1 to be augmented, empty classes set to zeros
%                         (original was: mode 1 class sets are made empty),
%                         loop data cancate over 2:length(i2) not 2:iv (removes bug)
%   5-09-01               DELSAMPS adapted for use with: single, uint8, etc.
%                         HORZCAT adapted for use with single, uint8, etc.
%                         removed use of SET and GET
%                         SUBSASGN added handling of other classes for data field
%                         SUBSREF adapted for use with single, uint8, etc.
%   5-03-01               SUBSREF added indexing into data using ()s (e.g. x.data(1:5,:) )
%   4-22-01               LOADOBJ updated version check #, fixed string comparison bug (version number as
%                         stored is STRING), fixed update code to copy non-dataset object first before updating,
%                         made version comparison & update incremental (do all which are needed),
%                         added set of DataSetVersion field
%   4-20-01               DELSAMPS fixed parentesis bug: changed "}" to ")"
%                         fixed index bug e.g. if includ = 6:10 and user asked to remove 8, it wouldn't
%                         remove anything BUT if user asked to remove 2, 7 would be removed)
%   4-12-01               SET fixed includ error if adding data to empty dataset
%                         SUBSASNG fixed includ error if adding data to empty dataset
%   4-11-01               SUBSASGN nearly the same as SET for datasets except added logic to take input like a
%                         SUBSASGN call and translate it into the correct info for the old SET routine
%                         fixed error in errors (missing [ ]s)
%                         modified error statements to make more sense with SUBSASGN call
%                         changed history logging function (renamed old one to keep it)
%                         SUBSREF converted from DATASET/GET
%                         added indexing into history vs. GET which doesn't allow that
%  10-10-00        2.01   DATASET add type = batch(cell), add includ {cell}, add history(cell)
%                         DISPLAY allow for type = batch(cell), add includ, history
%                         LOADOBJ, GET, SET add includ(cell) and history(cell)
%                         HORZCAT, VERTCAT not defined for batch
%                         added DELSAMPS method for soft delete (hard not yet available)
%  10-06-00        1.05   changed SET lines 218, 220, 222 to label, axisscale,
%                         axisscalename repspectively. changed help in GET.
%  09-01-00        1.04   changed SET to input a date when empty when using SET
%                         changed datasetdemo.m
%  08-30-00        1.03   beta,
%                         added moddate,
%                         added horizontal concatenation,
%                         vertical concatenation,
%                         changed display to not include 0x0 (must not
%                          be empty to see MxN)
%                         get moddate and datasetversion
%                         made moddate and date setable only if initially empty
%                         set moddate and datasetversion errors
%  08-17-00        0.02   beta,
%                         added SET field input can be cell,
%                         GET data can be data(:,1) (indexing capability)
%                         XPLDST overloaded for DATASET objects
%  08-16-00        0.01   beta, initial release
%  08-03-00        0.00   alpha
