function data = loadobj(x)
%DATASET/LOADOBJ load dataset object and update to present version.
%  If the loaded dataset object is newer than present dataset
%  object constructor it is converted to a structure.

%Copyright Eigenvector Research, Inc. 2000-2001
%nbg 8/16/00, 8/17/00, 8/30/00
%jms 4/22/01 
%  -updated version check # 
%  -fixed string comparison bug (version number as stored is STRING)
%  -fixed update code to copy non-dataset object first before updating
%  -made version comparison & update incremental (do all which are needed)
%  -added set of DataSetVersion field
%jms 5/21/02
%  -revised test logic to detect "same-fields but not same version #"
%  -added includ field orientation and test for includname presence
%jms 11/06/02
%  -updated dataset version number

%to change version number change "pv = " and "data.datasetversion ="
pv    = 3.02;             %present version of constructor
if isa(x.datasetversion,'char');
  xv    = str2num(x.datasetversion);  %version of the loaded dataset object
else
  xv    = x.datasetversion;           %version of the loaded dataset object
end;
if xv>pv
  
  disp('Warning: Loaded dataset object newer than present constructor.')
  disp('  Dataset object converted to structure.')
  data = struct(x);
  
elseif xv<=pv
  
  data = x;     %copy structure into what will become our dataset
  
  %update fields
  if xv<=0.02 %update from 0.02
    data.moddate = x.date;
    data.datasetversion = '1.05';  
  end;
  
  if xv<=1.05 %update from 1.05
    data.includ  = cell(ndims(x.data),2);
    for ii=1:length(data.includ)
      data.includ{ii} = [1:size(x.data,ii)];
    end
    data.history = 'Loaded from dataset object version <= 1.05.';
    data.datasetversion = '1.06';  %changed to 1.06 05/21/02
  end;

  if xv<=3.00  %update to 3.01
    %test for wrong includ field orientation and missing labels
    if size(data.includ,1) == 1 & size(data.includ,2) == ndims(x.data);
      data.includ = data.includ';
    end
    if size(data.includ,2) == 1;
      data.includ{ndims(x.data),2} = [];    %add empty labels
    end
    data.datasetversion = '3.01';  %changed to 3.01 05/21/02
  end
  
  if xv<=3.02
    data.datasetversion = '3.02';  %update to 3.02 is easy
  end
  
  if ~isa(data,'dataset');
    data = class(data,'dataset');
  end
  
end
