function explode(sdat,txt)
%DATASET/EXPLODE extracts variables from a DataSet object
%  EXPLODE writes the fields of a DataSet input
%  (sdat) to variables in the workspace with the same
%  variable names as the field names.
%  The optional string input (txt) appends a string
%    (txt) to the variable outputs.
%
%I/O: explode(sdat,txt)
%
%Example: explode(h,'01')
%
%See also: DATASET/GET, DATASET/SUBSREF

%Copyright Eigenvector Research, Inc. 2000-2001
%NBG 8/17/00, 9/1/00

if nargin<2,     txt = []; end

fields = fieldnames(sdat);
ii     = strmatch('datasetversion',fields);
ij     = 1:size(fields,1);
ij     = ij(find(ij~=ii));

for ii=ij
  eval(['dat = sdat.',fields{ii,:},';'])
  if isempty(txt)
    assignin('caller',fields{ii,:},dat)
  else
    assignin('caller',[fields{ii,:},txt],dat)
  end
end
