function display(data)
%DATASET/DISPLAY Command window display of a dataobj object.

%Copyright Eigenvector Research, Inc. 2000-2001
%nbg 8/3/00, 8/16/00, 8/17/00, 8/30/00, 10/10/00
%nbg 5/11/01 improved include display, and fixed size bug for cells (lablel, etc.)
%jms 10/19/01 cleaned up display, added "mode x" labels, added full-display of .title info

%display variable name
disp(' ');
disp([inputname(1),' = '])

%display field names/values (class/sizes)
%data.name, .type, .author, .date, .moddate
disp(['       name: ',data.name])
disp(['       type: ',data.type])
disp(['     author: ',data.author])
s         = data.date;
if isempty(s)
  disp(['       date:'])
else
  disp(['       date: ',datestr(datenum(s(1),s(2),s(3),s(4),s(5),s(6)),0)])
end
s         = data.moddate;
if isempty(s)
  disp(['    moddate:'])
else
  disp(['    moddate: ',datestr(datenum(s(1),s(2),s(3),s(4),s(5),s(6)),0)])
end

%data.data
s         = (['       data: ',int2str(size(data.data,1))]);
for ii=2:ndims(data.data)
  s       = [s,'x',int2str(size(data.data,ii))];
end
disp([s,' [',class(data.data),']'])

%data.label
[m1,n,n2] = size(data.label);
s         = [int2str(size(data.label,1)),'x',int2str(size(data.label,3))];
disp(['      label: {',s,'} [array (char)]'])
%individual label sizes        
if strcmp(class(data.label),'cell')
  s2      = ' ';
  s2      = s2(ones(m1,15));
  for ii=1:n2     %cell slabs
    s     = '';
    for ij=1:m1   %cell rows
      if ii==1; prefix = ['Mode ' num2str(ij) '  ']; else; prefix = ''; end
      if isempty(data.label{ij,1,ii})
        s1  = [prefix '[',data.label{ij,2,ii},': ] '];
      else
        s1  = [prefix '[', data.label{ij,2,ii},': ',int2str(size(data.label{ij,1,ii},1)), ...
            'x',int2str(size(data.label{ij,1,ii},2)),'] '];
      end
      s   = strvcat(s,s1);
    end
    s2    = [s2 s];
  end
end
disp(s2)

%data.axisscale
[m1,n,n2] = size(data.axisscale);
s         = [int2str(size(data.axisscale,1)),'x',int2str(size(data.axisscale,3))];
disp(['  axisscale: {',s,'} [vector (real)]'])
%individual data.scale sizes        
if strcmp(class(data.axisscale),'cell')
  s2        = ' ';
  s2        = s2(ones(m1,15));
  for ii=1:n2     %cell slabs
    s       = '';
    for ij=1:m1   %cell rows
      if ii==1; prefix = ['Mode ' num2str(ij) '  ']; else; prefix = ''; end
      if isempty(data.axisscale{ij,1,ii})
        s1    = [prefix '[',data.axisscale{ij,2,ii},': ] '];
      else
        s1    = [prefix '[',data.axisscale{ij,2,ii},': ',int2str(size(data.axisscale{ij,1,ii},1)), ...
            'x',int2str(size(data.axisscale{ij,1,ii},2)),'] '];
      end
      s     = strvcat(s,s1);
    end
    s2      = [s2 s];
  end
end
disp(s2)

%data.title
[m1,n,n2]   = size(data.title);
s           = [int2str(size(data.title,1)),'x',int2str(size(data.title,3))];
disp(['      title: {',s,'} [vector (char)]'])
%individual data.title sizes        
if strcmp(class(data.title),'cell')
  s2        = ' ';
  s2        = s2(ones(m1,15));
  for ii=1:n2     %cell slabs
    s       = '';
    for ij=1:m1   %cell rows
      if ii==1; prefix = ['Mode ' num2str(ij) '  ']; else; prefix = ''; end
      if isempty(data.title{ij,1,ii})
        s1    = [prefix '[',data.title{ij,2,ii},': ] '];
      else
        if size(data.title{ij,1,ii},2) > 20;
          %too many characters to actually display
          s1    = [prefix '[',data.title{ij,2,ii},': ',int2str(size(data.title{ij,1,ii},1)), ...
              'x',int2str(size(data.title{ij,1,ii},2)),'] '];
        else
          s1    = [prefix '[',data.title{ij,2,ii},': ''',data.title{ij,1,ii},'''] '];
        end
      end
      s     = strvcat(s,s1);
    end
    s2      = [s2 s];
  end
end
disp(s2)

%data.class
[m1,n,n2]   = size(data.class);
s           = [int2str(size(data.class,1)),'x',int2str(size(data.class,3))];
disp(['      class: {',s,'} [vector (integer)]'])
%individual data.class sizes        
if strcmp(class(data.class),'cell')
  s2        = ' ';
  s2        = s2(ones(m1,15));
  for ii=1:n2     %cell slabs
    s       = '';
    for ij=1:m1   %cell rows
      if ii==1; prefix = ['Mode ' num2str(ij) '  ']; else; prefix = ''; end
      if isempty(data.class{ij,1,ii})
        s1    = [prefix '[',data.class{ij,2,ii},': ] '];
      else
        s1    = [prefix '[',data.class{ij,2,ii},': ',int2str(size(data.class{ij,1,ii},1)), ...
            'x',int2str(size(data.class{ij,1,ii},2)),'] '];
      end
      s     = strvcat(s,s1);
    end
    s2      = [s2 s];
  end
end
disp(s2)

%data.includ (nbg added 5/11/01)
[m1,n,n2]   = size(data.includ);
s           = [int2str(m1),'x',int2str(n2)];
disp(['     includ: {',s,'} [vector (integer)]'])
%individual data.class sizes        
if strcmp(class(data.includ),'cell')
  s2        = ' ';
  s2        = s2(ones(m1,15));
  for ii=1:n2     %cell slabs
    s       = '';
    for ij=1:m1   %cell rows
      if ii==1; prefix = ['Mode ' num2str(ij) '  ']; else; prefix = ''; end
      if isempty(data.includ{ij,1,ii})
        s1    = [prefix '[',data.includ{ij,2,ii},': ] '];
      else
        s1    = [prefix '[',data.includ{ij,2,ii},': ',int2str(size(data.includ{ij,1,ii},1)), ...
            'x',int2str(size(data.includ{ij,1,ii},2)),'] '];
      end
      s     = strvcat(s,s1);
    end
    s2      = [s2 s];
  end
end
disp(s2)

%description
if isempty(data.description)
  disp(['description:'])
else
  disp(['description: ',data.description(1,:)])
  if size(data.description,1)>1
    for ii=2:size(data.description)
      disp(['             ',data.description(ii,:)])
    end
  end
end

%history
if isempty(data.history)
  disp(['    history:'])
else
  s          = int2str(size(data.history,1));
  disp(['    history: {',s,'x1 cell} [array (char)]'])
end

%data.userdata
%note, include some info about contents
s = '   userdata: ';
if isempty(data.userdata)
  disp(s)
else
  s = [s,int2str(size(data.userdata,1))];
  for ii=2:ndims(data.userdata)
    s = [s,'x',int2str(size(data.userdata,ii))];
  end
  disp([s,' [',class(data.userdata),']'])
end