function x = delsamps(x,inds,vdim,flag)
%DELSAMPS Marks/Deletes samples from dataset objects.
%  DELSAMPS is used to mark rows or columns to be
%  "excluded" but still be retaind in a DataSet (i.e.
%  soft delete). It can also be used to permanently 
%  remove rows or columns from a DataSet object (i.e.
%  hard delete).
%  Inputs are the original DataSet object (data) and
%  the indices to mark (inds).
%  Optional input (vdim) is the mode/dimension to mark
%    1=rows {default}, and
%    2=columns, etc.
%  Optional input (flag) indicates to mark/soft delete 
%  when set to 1 {default}, hard delete when set to 2, 
%  or hard "keep"/reorder when set to 3 (when flag is 3, 
%  inds are indices to keep - also allows reordering).
%  The output is the edited DataSet object (eddata).
% 
%I/O: eddata = delsamps(data,inds,vdim,flag)

%Copyright Eigenvector Research, Inc. 2000-2002
%nbg 10/11/00
%jms 4/20/01 
%  - fixed parentesis bug (there was a "}" where there should have been a ")" )
%  - fixed index bug (e.g. if includ = 6:10 and user
%      asked to remove 8, it wouldn't remove anything BUT
%      if user asked to remove 2, 7 would be removed)
%jms 5/9/01 - adapted for use with data being other classes (single, uint8, etc).
%nbg 5/11/01 - terminated line 67 x.includ{vdim} = setdiff(x.includ{vdim},inds) with ;
%nbg 5/14/01 - added "hard delete" flag==2
%jms 9/9/02 -added "hard keep/reorder" option (flag==3)
%   -make history notation for both soft AND hard deletions

if ~isa(x,'dataset') %redundant test for overloaded methods
  error('Function for DATASET ojects only.')
end
if nargin<2
  error('2 inputs required.')
elseif isempty(x.data)
  warning('Dataset data field empty.')
end
if nargin<3
  vdim     = 1;
elseif isempty(vdim)                       %nbg 5/14/01
  vdim     = 1;
elseif isa(x.data,'cell')
  if (vdim>ndims(x.data{1}))|(vdim<1)
    error(['vdim must be integer in [1:',int2str(ndims(x.data{1})),'].'])
  end
else
  if (vdim>ndims(x.data))|(vdim<1)
    error(['vdim must be integer in [1:',int2str(ndims(x.data)),'].'])
  end
end
if nargin<4
  flag     = 1;
elseif isempty(find(flag==[1 2 3]))
  error('Unknown option for ''flag''.')
end

if isa(x.data,'cell')
  nsize    = size(x.data{1});
  nsize(1) = length(x.data);
else
  nsize    = size(x.data);
end
nsize      = nsize(vdim);

if any(inds<1)|(max(inds)>nsize)
  error(['For vdim = ',int2str(vdim),', inds must be integers in [1:',int2str(nsize),'].'])
end

if isempty(inputname(2))
  %might try to identify and reproduce the vector here
  indsin   = '?FunctionCall';
else
  indsin   = inputname(2);
end
x.history{length(x.history)+1} = ['delsamps(',inputname(1),',',indsin,',', ...
    int2str(vdim),',',int2str(flag),');'];

if flag==1
  x.includ{vdim,1} = setdiff(x.includ{vdim,1},inds);
  %find difference between what exists and what we're being asked to remove
  
  if isempty(x.date)
    x.date          = clock;
    x.moddate       = x.date;
  else
    x.moddate       = clock;
  end
elseif flag==2 | flag==3
  %this is a "hard" delete and corresponds to constructing a new data set
  x.date            = clock;
  x.moddate         = x.date;
  
  iall              = 1:size(x.data,vdim);
  if flag==2
    iuse            = setdiff(iall,inds);
  else    %flag==3 means "hard keep" - keep indicated inds discarding rest (allows reordering too!)
    iuse            = inds;
  end
  if isempty(iuse)
    warning('All samples deleted.')
    x = [];
  else

    S      = [];
    S.type = '()';
    S.subs = cell(1,ndims(x.data));
    [S.subs{1:ndims(x.data)}] = deal(':');   % gives  {':' ':' ':' ...}
    S.subs{vdim}              = iuse;        % insert indices into appropriate dim
    x.data                    = subsref(x.data,S);
    
    %old code to do above using eval:
    %     s         = cell(2,1); s{1}  = ',';      s{2}  = ':';      s  = s(:,ones(1,ndims(x.data)));
    %     s{2,vdim} = ['iuse']'; s     = char(s)'; s     = s(2:end);
    %     eval(['x.data     = x.data(',s,');'])
    
    for ii=1:size(x.label,3)
      if ~isempty(x.label{vdim,1,ii})
        x.label{vdim,1,ii} = deblank(x.label{vdim,1,ii}(iuse,:));
        x.label{vdim,2,ii} = deblank(x.label{vdim,2,ii});
      end
    end
    for ii=1:size(x.axisscale,3)
      if ~isempty(x.axisscale{vdim,1,ii})
        x.axisscale{vdim,1,ii} = x.axisscale{vdim,1,ii}(iuse);
        x.axisscale{vdim,2,ii} = x.axisscale{vdim,2,ii};
      end
    end
    for ii=1:size(x.title,3)
      if ~isempty(x.title{vdim,1,ii})
        x.label{vdim,1,ii} = deblank(x.label{vdim,1,ii});
        x.label{vdim,2,ii} = deblank(x.label{vdim,2,ii});
      end
    end
    for ii=1:size(x.class,3)
      if ~isempty(x.class{vdim,1,ii})
        x.class{vdim,1,ii} = x.class{vdim,1,ii}(iuse);
        x.class{vdim,2,ii} = x.class{vdim,2,ii};
      end
    end
    for ii=1:size(x.includ,3)
      if ~isempty(x.includ{vdim,1,ii})
        y                      = zeros(1,length(iall));
        y(x.includ{vdim,1,ii}) = ones(1,length(x.includ{vdim,1,ii}));
        x.includ{vdim,1,ii}    = find(y(iuse));
        x.includ{vdim,2,ii}    = x.includ{vdim,2,ii};
      end
    end
  end
end