function b = subsref(a,index)
switch index(1).type
case '.'
   switch lower(index(1).subs)
   case 'labels'
      if length(a) == 1
         b = a.labels{1};
      else
         b = a.labels;
      end
      if length(index)>1
         error('Invalid reference')
      end
      
   case 'name'
      if length(index)>1
         if strcmp(index(2).subs,'or')
            if length(a) == 1
               b = a.orname{1};
            else
               b = a.orname;
            end
         else
            error('Invalid reference')
         end
      else
         if length(a) == 1
            b = a.name{1};
         else
            b = a.name;
         end
      end
      
   case 'dims'
      b = [];
      if length(a) == 1
         b = sum(a.selected{1});
      else
         for i = 1:length(a)
            b{i} = sum(a.selected{i});
         end
      end
      if length(index)>1
         b = subsref(b,index(2:end));
      end
      
   case 'sel'
       if length(index) == 1
           index(2).type    = '{}';
           index(2).subs{1} = 1:size(a,2);
       end 
       if length(index) == 2
         if strcmp(index(2).type,'{}') & length(index(2).subs) == 1
            if length(a) == 1
               b = find(any(a.selected{1}(:,index(2).subs{1}),2));
            else
               for i = 1:length(a)
                  b{i} = find(any(a.selected{i}(:,index(2).subs{1}),2));
               end
            end
         else
            error('Invalid reference')
         end
      else
         error('Invalid reference')
      end
   otherwise
      error('Invalid reference')
   end
   
case '()'
   if length(a) == 1
      b = a;
      if length(index(1).subs) == 1
         if ischar(index(1).subs{1})
            index(1).subs{1} = 1:size(b.labels{1},1);
         end
         b.labels{1}   = b.labels{1}(index(1).subs{1},:);
         b.selected{1} = b.selected{1}(index(1).subs{1},:);
      else
         error('Invalid reference')
      end
      if length(index) > 1
         b = subsref(b,index(2:end));
      end
   else
      error('Invalid reference')
   end
   
case '{}'
   if length(index(1).subs) == 1
      if ischar(index(1).subs{1})
          index(1).subs{1} = 1:length(b);
      end
      b          = a;
      b.name     = b.name(index(1).subs{1});
      b.labels   = b.labels(index(1).subs{1});
      b.selected = b.selected(index(1).subs{1});
      b.orname   = b.orname(index(1).subs{1});
      if length(index) > 1
         b = subsref(b,index(2:end));
      end
   else 
      error('Invalid reference')
   end
end