function b = subsasgn(a,index,val)
switch index(1).type
case '.'
   if length(a) == 1 & length(index) == 1
      index = struct('type',{'()','.'},'subs',{':',index.subs});
      b = subsasgn(a,index,val);
   else
      error('Invalid reference')
   end
   
case '()'
   if length(a) == 1 & length(index) == 2 & strcmp(index(2).type,'.') & length(index(1).subs) == 1
      b = a;
      if ischar(index(1).subs)
         index(1).subs = {1:size(b.labels{1},1)};
      end
      switch lower(index(2).subs)
      case 'sel'
         if length(val) > 1
            error('Selection cannot be applied to more than one category at the same time')
         end
         if val > size(b,2)
            error('Assignment exceeds the number of categories')
         end
         b.selected{1}(index(1).subs{1},val) = 1;
         if size(b,2) > 1
            b.selected{1}(index(1).subs{1},[1:val-1 val+1:size(b,2)]) = 0;
         end
         b = update(b);
         
      case 'desel'
         b = a;
         if max(val) > size(b,2)
            error('Assignment exceeds the number of categories')
         end
         b.selected{1}(index(1).subs{1},val) = 0;
         b                                   = Update(b);
      otherwise
         error('Invalid reference')
      end
   else
      error('Invalid reference')
   end
   
case '{}'
   if length(index(1).subs) == 1 & length(index(1).subs{1}) == 1 & length(index) >= 2 & ~ischar(index(1).subs{1})
      [c,b]                        = deal(a);
      c.name                       = c.name(index(1).subs{1});
      c.labels                     = c.labels(index(1).subs{1});
      c.selected                   = c.selected(index(1).subs{1});
      c                            = subsasgn(c,index(2:end),val);
      b.name(index(1).subs{1})     = c.name;
      b.labels(index(1).subs{1})   = c.labels;
      b.selected(index(1).subs{1}) = c.selected;
   else
      error('Invalid reference')
   end
end

