function MarkLab = marklab(Labels,Markers);
MarkLab = struct('labels',[],'name',[],'markers',[],'selected',[],'orname',[]);
if nargin == 0
   MarkLab = class(MarkLab,'marklab');
end
   
%Check on labels

% Cu_FIX_2011
if (isa(Labels,'Label')	 || isa(Labels,'Label'))
    Labels = {Labels};
end
if isa(Labels,'cell')
    % Cu_FIX_2011

   if (~all(cellfun('isclass',Labels,'label'))  ...
           && ~all(cellfun('isclass',Labels,'Label')))
      error('Labels must be a cell whose elements are label objects')
   end
else
   error('Labels must be a cell whose elements are label objects')
end

% % %
% % % Orig
% % %
% % if (isa(Labels,'label') )
% %     Labels = {Labels};
% % end
% % if isa(Labels,'cell')
% %    
% % 
% %    if (~all(cellfun('isclass',Labels,'label')))
% %       error('Labels must be a cell whose elements are label objects')
% %    end
% % else
% %    error('Labels must be a cell whose elements are label objects')
% % end
% % 

%Check on markers
if nargin < 2
    %Default Marker
    Markers = ' * ';
elseif ~ischar(Markers)
   error('Markers must be contained in a char array')
end
%Check uniqueness for markers
if size(Markers,1) ~= size(unique(Markers,'rows'),1)
    error('Assignment to a certain category must be caracterised by a different marker')
end

%Create the MarkLabObject
MarkLab.markers = Markers;
for i = 1:length(Labels)
   MarkLab.name{i}     = Labels{i}.name;
   MarkLab.labels{i}   = char([32*ones(length(Labels{i}),size(Markers,2)),char(Labels{i})]);
   MarkLab.selected{i} = logical(zeros(length(Labels{i}),size(Markers,1)));
   MarkLab.orname{i}   = MarkLab.name{i};
end
MarkLab = class(MarkLab,'marklab');
return
