function b = subsref(a,index)
% Subscripted reference for label object
% For more details: help label
%   
%   Author: Giorgio Tomasi
%       Royal Agricolture University, MLI, LMT
%       1958 Frederiksberg C
%       Danmark
%       email: gt@kvl.dk
b = struct('name','','labels',[],'scalars',[],'axislabels',[],'measun','');
switch index(1).type
case '()'
   switch class(index(1).subs{1})
   case 'char'
      if strcmp(index(1).subs{1},':')
         b = a;
      end
   case 'double' 
      if a.flag
         b = label([],a.deflab,a.scalars(index(1).subs{1}),a.axislabels,a.name,a.measun);
      else
         b = label(a.labels(index(1).subs{1}),a.deflab,a.scalars(index(1).subs{1}),a.axislabels,a.name,a.measun);
      end
   otherwise
      error('Inapplicable reference')
   end   
case '.'
   switch lower(index(1).subs)
   case 'labels'
      b = a.labels;
   case 'scalars'
      b = a.scalars;
   case 'axislabels'
      b = a.axislabels;
   case 'name'
      b = a.name;
   case 'deflab'
      b = a.deflab;
   case 'measun'
      b = a.measun;
   case 'flag'
      b = b.flag;
   otherwise
      error('No property with this name')
   end
case '{}'
   error('{} reference is not allowed')
end
if length(index) > 1
   b = subsref(b,index(2:end));
end
