function c = subsasgn(a,index,val)
% Subscripted assignment for label object
% For more details: help label
%   
%   Author: Giorgio Tomasi
%       Royal Agricolture University, MLI, LMT
%       1958 Frederiksberg C
%       Danmark
%       email: gt@kvl.dk
%
% $ Version 3.0 $ 01.08.2011 $ Label -- capital letter $
%
if length(index) > 1
   error('No more than one assignment index can be used')
end
 
% Cu_FIX_2011
if (strcmp(class(a),'label') || strcmp(class(a),'Label')) 
   c = a;
else
   c = label;
end
switch index.type
case '()'
   if length(index.subs) > 1
      error('Error')
   end
   switch class(index.subs{1})
   case 'char'
      if strcmp(index.subs,':')
         if length(a) == length(val(:))
            switch lower(class(val))
            case {'cell','double'}
               c = label(val,a.deflab,a.scalars,a.axislabels,a.name,a.measun);
            case 'label'
               c = val;
            otherwise
               error('Type mismatch error')
            end
         elseif isempty(val)
            c = [];
         else
            error('Unequal lengths')
         end
      end
   case 'double'
      if ischar(val)
         val = cellstr(val);
      end
      if size(val,1) == length(index.subs{1})
         switch lower(class(val))
         case 'cell'
            if all(cellfun('isclass',val,'char'))
               c.labels(index.subs{1}) = val(:);
               b = cellfun('length',c.labels) == 0;
               if any(b) | length(a.labels) ~= length(c.labels)
                  c.labels(b) = cellstr([ones(sum(b),1) * c.deflab,char(strrep(cellstr(num2str(find(b))),' ',''))]);
                  c.scalars   = [1:length(c.labels)]';
               end
            end
            c.flag = 0;
            
         case 'double'
            if isempty(c.labels)
               c.labels  = cell(max(index.subs{1}),1);
               c.scalars = [1:length(a.labels)]';   
            end
            c.labels(index.subs{1})  = cellstr([ones(length(val),1) * a.deflab,char(strrep(cellstr(num2str(val(:))),' ',''))]);
            b                        = cellfun('length',c.labels) == 0;
            if any(b)
               a.labels(b) = cellstr([ones(sum(b),1) * c.deflab,char(strrep(cellstr(num2str(find(b(:)))),' ',''))]);
               if c.flag
                  c.scalars   = [1:length(c.labels)]';
               else
                  c.scalars(b)= find(b);
               end
            end
            c.flag = 0;
            
         case 'label'
            if ~isempty(val.labels)
               c.labels(index.subs{1}) = val.labels;
               c.scalars(index.subs{1}) = val.scalars;
            end
            b = cellfun('length',c.labels) == 0;
            if any(b)
               c.labels(b) = cellstr([ones(sum(b),1) * c.deflab,char(strrep(cellstr(num2str(find(b(:)))),' ',''))]);
               if c.flag
                  c.scalars   = [1:length(c.labels)]';
               else
                  c.scalars(b)= find(b);
               end
            end
            %if length(unique(c.scalars))~=length(c) 
            %   c.scalars = [1:length(c)]';
            %end
            c.flag = 0;
            
         otherwise
            error('Error')
         end
      elseif isempty(val)
         if length(index.subs{1}) == length(c.labels)
            c = [];
            return
         end
         c.labels(index.subs{1}) = [];
         c.scalars(index.subs{1}) = [];
      end
   end   
   
case '.'
   switch lower(index.subs) 
   case 'labels'
      if length(val(:)) ~= length(a)
         error('Unequal lengths')
      end
      c = label(val,a.deflab,a.scalars,a.axislabels,a.name,a.measun);
      a.flag = 0;
      
   case 'scalars'
      if length(val(:)) ~= length(a)
         error('Unequal lengths')
      end
      if a.flag
         c = label([],a.deflab,val,a.axislabels,a.name,a.measun);
      else
         c = label(a.labels,a.deflab,val,a.axislabels,a.name,a.measun);
      end
      
   case 'name'
      if ischar(val)
         c.name = val(:)';
      else
         error('Type mismatch error')
      end
      
   case 'deflab'
      if ischar(val)
         c.deflab = val(:)';
      else
         error('Type mismatch error')
      end
      
   case 'axislabels'
      c = label(a.labels,a.deflab,a.scalars,val,a.name,a.measun);
      
   case 'measun'
      if ischar(val)
         c.measun = val(:)';
      else
         error('Type mismatch error')
      end
      
   otherwise
      error('Error')
   end
case '{}'
   error('{} reference is not allowed')
end
%if isa(c,'label')
%   if length(c.scalars) ~= length(unique(c.scalars)) | length(c.labels) ~= length(unique(c.labels))
%      error('No label or scalar can be repeated');
%   end
%end
