function b = subsref(a,index)
b = a;
switch index(1).type
case '()'
   if length(index(1).subs)>ndims(a)
      error('Index exceed dimensions')
   end
   for j = 1:ndims(a)
      if j > size(index(1).subs,2)
         index(1).subs{j} = 1:size(a,j);
      end
      if isa(index(1).subs{j},'char')
         if strcmp(index(1).subs{j},':')
            index(1).subs{j} = 1:size(a,j);
         end
      end
      if max(index(1).subs{j})>size(a,j)
         error('Index exceed data set dimensions')
      end
      c           = a.labels{j};
      b.labels{j} = c(index(1).subs{j});
      b.dims(j)   = length(b.labels{j});
   end
   
case '.'
   switch lower(index(1).subs)
   case 'dims'
      b = b.dims;
      
   case 'name'
      b = b.name;
      
   case 'type'
      b = b.type;
            
   case 'description'
      b = b.description;
      
   case 'author'
      b = b.author;
      
   case 'scalars'
      b = [];
      for i = 1:ndims(a)
         b{i} =  a.labels{i}.scalars;
      end
      
   case 'deflab'
      b = [];
      for i = 1:ndims(a)
         b{i} = a.labels{i}.deflab;
      end
      
   case 'labels'
      b = [];
      for i = 1:ndims(a)
         b{i} =  a.labels{i}.labels;
      end
      
   case 'labobj'
      b = a.labels;
      
   case 'axislabels'
      b = [];
      for i = 1:ndims(a)
         b{i} =  a.labels{i}.axislabels;
      end
      
   case 'modenames'
      b = [];
      for i = 1:ndims(a)
         b{i} =  a.labels{i}.name;
      end
      
	case 'measunits'
      b = [];
      for i = 1:ndims(a)
         b{i} =  a.labels{i}.measun;
      end
      
   otherwise
      error('Invalid reference')
   end
otherwise
   error('Type mismatch error')
end
Fl = 1;
if length(index) > 1
   if strcmp(index(2).type,'.')
      if strcmp(index(2).subs,'data')
         Fl = 0;
      end
   end
   if Fl
      b = subsref(b,index(2:end));
   end
end
