function a = subasgn(a,index,Val)
switch index(1).type
case '.'
   if length(index) > 1 & ~strcmp(index(1).subs,'labels')
      error('Type mismatch error')
   end
   switch lower(index(1).subs)

   % orig -- Cu_FIX_2011    
   %         switch index(1).subs

   case 'description'
      if isa(Val,'char')
         Val = cellstr(Val);
      end 
      if ~isa(Val,'cell')
         error('Description must be either a char array or a cell vector of chars')
      elseif all(cellfun('isclass',Val,'char'))
         a.description = Val(:);
      end
      
   case 'name' 
      if isa(Val,'char')
         a.name = Val;
      else
         error('Name must be a string')
      end
      
   case 'type'
      switch lower(Val)
      case {'batch','data','image'}
         a.type = [upper(Val(1)), lower(Val(2:end))];
      otherwise
         error('Type not supported')
      end
      
   case 'author'
      if isa(Val,'char')
         Val = cellstr(Val);
      end
      if ~isa(Val,'cell')
         error('Author must be either a char array or a cell vector of chars')
      elseif all(cellfun('isclass',Val,'char'))
         a.author = Val(:);
      end
      
   case 'labels'
      if length(index) > 1
         V = a.labels;
         if strcmp(index(2).type,'{}')
            if length(index) > 2
               V{index(2).subs{:}} = subsasgn(V{index(2).subs{:}},index(3:end),Val);
            else
               V{index(2).subs{:}} = Val;
            end
         elseif strcmp(index(2).type,'()')
            if length(index) > 2 | ~isa(Val,'cell')
               error('Invalid reference')
            end
            V(index(2).subs{:}) = Val;
         elseif strcmp(index(2).type,'.')
            if strcmp(index(2).subs,'reorder')
               V      = Val;
               for i = 1:length(V)
                  a.dims(i) = length(V{i});
               end
            else
               error('Invalid reference')
            end
         end
      else
         V = Val;
      end
      [a.labels,a.dims] = CheckLabels(V,a.dims);
      
   otherwise
      warning('Invalid property name')
      disp(' ')
   end
   
case '()'
   if length(index) > 1
      if strcmp(index(2).type,'.')
         error(['It is not possible to use the syntax:'...
               'Content(...).',index(2).subs,' = Value']) 
      else
         error('Invalid reference')
      end
   end
   if length(index(1).subs) > ndims(a)
      error('Index exceed data set dimensions')
   end
   for j=1:ndims(a)
      if j > size(index(1).subs,2)
         index(1).subs{j}=1:size(a,j);
      end
      if isa(index(1).subs{j},'char')
         if strcmp(index(1).subs{j},':')
            index(1).subs{j} = 1:size(a,j);
         end
      end
      if length(index(1).subs{j}) ~= size(Val,j) & ~isempty(Val)
         error('Unequal dimensions on the two sides of the assignment')
      end
   end
   if isempty(Val)
      DimEm = cellfun('length',index(1).subs) == size(a);
      if sum(DimEm) == ndims(a)
         a = [];
         return
      elseif sum(DimEm) == ndims(a)-1
         j = find(~DimEm);
         KeepInd = 1:size(a,j);
         KeepInd(index(1).subs{j}) = [];
         a.labels{j} = a.labels{j}(KeepInd);
         a.dims(j)   = length(KeepInd); 
      else
         error('A null assignment can have only one non colon index')
      end
      
   elseif isa(Val,'content')
      for j = 1:ndims(a)
         if max(index(1).subs{j}) > size(a,j)
            a.labels{j}(index(1).subs{j}) = Val.labels{j};
            a.dims(j) = max(index(1).subs{j});
         end
      end
      
   else
      error('Type mismatch error')
   end
   
otherwise 
   error('Type mismatch error')
end
