function [Labs,DataDims] = checklabels(Labs,DataDims)
if ~iscell(Labs)
   error('Inadequate value for ''labels'' property')
   return
end
ClassLabs                                 = 2 * cellfun('isclass',Labs(:),'char') + ...
   3 * cellfun('isclass',Labs(:),'cell') + ...
   4 * cellfun('isclass',Labs(:),'label') +   4 * cellfun('isclass',Labs(:),'Label') + ...
   5 * cellfun('isclass',Labs(:),'double');

ClassLabs(cellfun('length',Labs(:)) == 0) = 1;
if any(ClassLabs == 0)
   error('Inadequate value for ''labels'' property');
end 
Dims(ClassLabs == 2) = cellfun('size',Labs(ClassLabs == 2),1);
Dims(ClassLabs == 3) = cellfun('length',Labs(ClassLabs == 3));
Dims(ClassLabs == 5) = cellfun('length',Labs(ClassLabs == 5));
b                    = find(ClassLabs == 4);
for i = 1:length(b)
   Dims(b(i)) = length(Labs{b(i)});
end
if nargin == 1
   if any(ClassLabs == 1)
      error('Labels contain empty arrays value for ''labels'' property');
   end
   DataDims = Dims(:)';
else
   if any(DataDims(:) ~= Dims(:))
      error(['Inconsistent labels length for mode(s) ',num2str(find(DataDims(:) ~= Dims(:)))])
   end
end
if all(ClassLabs == 4)
   return
end
if all(ClassLabs == 1)
   error('All the labels are empty')
else
   if any(ClassLabs == 1)
      for i = find(ClassLabs == 1)
         if i == 1
            Labs{i} = label(1:DataDims(i),'Sam.',[],'','Samples');
         else
            Labs{i} = label(1:DataDims(i),'Var.',[],'',sprintf('Mode %i',i));
         end
      end
   end
end
if any(ClassLabs == 2)
   for i = find(ClassLabs == 2)
      Labs{i}      = cellstr(Labs{i});
      ClassLabs(i) = 3;
   end
end
if any(ClassLabs == 3)
   for i = find(ClassLabs == 3)
      if ~all(cellfun('isclass',Labs{i},'char')) 
         error('Inadequate value for ''labels'' property')
      end
      if i == 1
         Labs{i} = label(Labs{i},'Sam.',[],'','Samples');
      else
         Labs{i} = label(Labs{i},'Sam.',[],'',sprintf('Mode %g',i));
      end
   end
end
for i = 1:length(DataDims)
   Labs{i} = label(Labs{i});
   if isempty(Labs{i}.name)
      Labs{i}.name = sprintf('Mode %g',i);
   end
end

