function LabsA=Merge(LabsA,s,LabsB,DataDims)
Labels = [];
NDim = length(DataDims);
if isempty(s)
   for i=1:NDim
      s.subs{i}=1:DataDims(i);
   end
end
for j=1:NDim
   if ~isempty(LabsA)
      if ~isempty(LabsB)
         if ~isempty(LabsA(j).scalars) 
            if ~isempty(LabsB(j).scalars)
               if ~all(LabsB(j).scalars==LabsA(j).scalars(s(1).subs{j}))
                  error(['The scalars in the ',num2str(j),'. mode do not match'])
               end
            end
         else
            if ~isempty(LabsB(j).scalars)
               if length(LabsB(j).scalars) == DataDims(j)
                  LabsA(j).scalars(s(1).subs{j}) = LabsB(j).scalars(:);
                  LabsA(j).scalars = LabsA(j).scalars(:);
               else
                  warning(['The scalars in the ',num2str(j),'. mode will be disregarded'])
               end
            end
         end
         if ~isempty(LabsA(j).labels)
            if ~isempty(LabsB(j).labels)
               if ~all(strcmp(LabsB(j).labels(:),LabsA(j).labels(s(1).subs{j})))
                  error(['The labels in the ',num2str(j),'. mode do not match'])
               end
            end
         else
            if ~isempty(LabsB(j).labels)
               if length(LabsB(j).labels) == DataDims(j)
                  LabsA(j).labels(s(1).subs{j}) = LabsB(j).labels(:);
                  LabsA(j).labels = LabsA(j).labels(:);
               else
                  warning(['The labels of in the ',num2str(j),'. mode will be disregarded'])
               end
            end
         end
         if ~isempty(LabsA(j).axislabels)
            if ~strcmp(LabsA(j).axislabels,LabsB(j).axislabels)
               error(['The axis labels of the ',num2str(j),'. mode do not match'])
            end
         else
            if ~isempty(LabsB(j).axislabels)
               LabsA(j).axislabels = LabsB(j).axislabels;
            end
         end
      end
   else
      if ~isempty(LabsB)
         if ~isempty(LabsB(j).scalars)
            if length(LabsB(j).scalars) == DataDims(j)
               LabsA(j).scalars(s(1).subs{j}) = LabsB(j).scalars(:);
               LabsA(j).scalars = LabsA(j).scalars(:);
            else
               warning(['The scalars of in the ',num2str(j),'. mode will be disregarded'])
            end
         end
         if ~isempty(LabsB(j).labels)
            if length(LabsB(j).labels) == DataDims(j)
               LabsA(j).labels(s(1).subs{j}) = LabsB(j).labels(:);
               LabsA(j).labels = LabsA(j).labels(:);
            else
               warning(['The labels of in the ',num2str(j),'. mode will be disregarded'])
            end
         end
         if ~isempty(LabsB(j).axislabels)
            LabsA(j).axislabels = LabsB(j).axislabels;
         end
      end
   end
end