function Content = content(varargin)
%Content object
%
%Syntax: Content = content(Labels,['field1',value1[,'field2',value2,[...]]]
%
%Fields       Allowed values
%
%Name       : string of char, if it not inserted the name of the matrix containing the data will be used.
%             Default: Matrix
%Type       : can either be 'data' (only one implemented so far), 'batch' or 'image'
%             Default: Data
%Author     : either matrix of chars or cell of strings (the cell is vectorised when it is not a vector)
%Description: either matrix of chars or cell of strings (the cell is vectorised when it is not a vector)
%Labels     : cell vector - length must be equal to ndims(data))
%             containing label objects or cell vectors of strings or char arrays or vectors of doubles

ContentStruct = struct('name','Matrix',...   %Array name
   'type','Data',...                         %Type of data
   'author','',...                           %Author of the data set
   'labels',[],...                           %Labels
   'dims',[0 0],...                             %Dimensions
   'description','');                        %Description of the data set

if ~nargin
   Content = class(ContentStruct,'content');
   
else
   Content = ContentStruct;
   if isa(varargin{1},'cell')
      if ~isempty(inputname(1))
         Content.name = inputname(1);
      else
         Content.name = 'Matrix';
      end
      varargin = [{'labels'};varargin(:)];
   elseif isa(varargin{1},'double')
      if any(rem(varargin{1},1))
         error('Dimensions must be integers')
      else
         t{1} = label(1:varargin{1}(1),'Sam.',[],'','Samples');
         for i=2:length(varargin{1})
            t{i} = label(1:varargin{1}(i),'Var.',[],'',sprintf('Mode %i',i));
         end
         varargin{1} = t;
         varargin = [{'labels'};varargin(:)];
      end
   else
      error('The first parameter must be the labels or a vector of integers')
   end
   if rem(length(varargin),2)
      error('Properties'' names and their values must be inserted in pairs')
   end
   Prop = varargin(1:2:end);
   if length(unique(Prop)) ~= length(Prop)
      error('Properties can be defined only once')
   end
   if ~all(cellfun('isclass',Prop,'char'))
      error('Invalid content property name')
   end
   for i = 1:2:length(varargin)
      switch lower(varargin{i})         
      case 'name'
         if isa(varargin{i+1},'char')
            Content.name = varargin{i+1};
         else
            error('Array''s name must be a char array')
         end
         
      case 'type'
         switch lower(varargin{i+1})
         case {'batch','data','image'}
            Content.type = [upper(varargin{i+1}(1)), lower(varargin{i+1}(2:end))];
         otherwise
            error('Type not allowed')
         end
         
      case 'author'
         if isa(varargin{i+1},'char')
            varargin{i+1} = cellstr(varargin{i+1});
         end
         if ~isa(varargin{i+1},'cell')
            error('Author must be either a char array or a cell vector of chars')
         elseif all(cellfun('isclass',varargin{i + 1},'char'))
            Content.author = varargin{i+1}(:);
         end
         
      case 'description'
         if isa(varargin{i+1},'char')
            varargin{i+1} = cellstr(varargin{i+1});
         end
         if ~isa(varargin{i+1},'cell')
            error('Description must be either a char array or a cell vector of chars')
         elseif all(cellfun('isclass',varargin{i + 1},'char'))
            Content.description = varargin{i + 1}(:);
         end
                  
      case 'labels'
         [Content.labels,Content.dims] = checklabels(varargin{i+1});
      end 
      
   end
   Content = class(Content,'content');
end
