function b = subsref(a,index)
% Subscripted reference for cbdataset object
% For more details: help cbdataset
%   
%   Author: Giorgio Tomasi
%       Royal Agricolture University, MLI, LMT
%       1958 Frederiksberg C
%       Danmark
%       email: gt@kvl.dk
b = a;
switch index(1).type
case '()'
   if length(index(1).subs)>ndims(a.data)
      error('Index exceed cbdataset dimensions')
   end
   c = subsref(b.content,index(1));
   for j = 1:ndims(a.data)
      if j > size(index(1).subs,2)
         index(1).subs{j} = 1:size(a.data,j);
      end
      if isa(index(1).subs{j},'char')
         if strcmp(index(1).subs{j},':')
            index(1).subs{j} = 1:size(a.data,j);
         end
      end
      if max(index(1).subs{j}) > size(a.data,j)
         error('Index exceeds cbdataset dimensions')
      end
   end
   if isa(c,'content')
%% Cu_FIX_2011
% orig 
% b.content = c;
      b.Content = c;
      b.data    = a.data(index(1).subs{:});
      b.lastmod = fix(clock);
   else
      b = c;
   end
   if length(index) > 1
      b = subsref(b,index(2:end));
   end
   
case '.'
   switch lower(index(1).subs)
   case {'dims','name','description','author','scalars','labels','axislabels','deflab','modenames','measunits','labobj','type'}
      b = subsref(b.content,index);
   case 'userdata'
      b = b.userdata;
   case 'data'
      b = b.data;
   case 'modified'
      b = b.lastmod;
   otherwise
      error('Improper reference')
   end
otherwise
   error('Type mismatch error')
end
