function a = subsasgn(a,index,Val)
% Subscripted assignment for cbdataset object
% For more details: help cbdataset
%   
%   Author: Giorgio Tomasi
%       Royal Agricolture University, MLI, LMT
%       1958 Frederiksberg C
%       Danmark
%       email: gt@kvl.dk

switch index(1).type
case '.' 
   switch lower(index(1).subs) 

%    Cu_FIX_2011            
%        %% orig  switch index(1).subs    
   case 'data'
      if length(index) > 1 & ~strcmp(index(1).subs,'labels')
         error('Type mismatch error')
      end
      if isempty(Val)
         error('A cbdataset cannot be empty')
      end
      if isa(Val,'cbdataset')
         Val = Val.data;
      end
      if ndims(a.data) == ndims(Val)
         if all(size(a.data) == size(Val));
            a.data    = Val;
         else
            error('Assignment dimension mismatch')
         end
      elseif isempty(a.data)
         a.data    = Val;
         a.lastmod = fix(clock);
      end
      
   case 'userdata'
      a.userdata = Val;
      
   case {'description','name','type','author','labels'}
       
       
       %% Cu_FIX_2011
      % orig
      %  a.content = subsasgn(a.content,index,Val); 
       
     %index.subs = 'Name';
     aa = subsasgn(a.Content,index,Val);
      a.Content =  aa; 
      return
   
      
      
   otherwise
      warning('The requested property does not exist or it is not available')
      disp(' ')
      
   end
   
case '()'
   if length(index) > 1
      if strcmp(index(2).type,'.')
         error(['It is not possible to use the syntax:'...
               'Content(...).',index(2).subs,' = Value']) 
      else
         error('Invalid reference')
      end
   end
   if length(index(1).subs) > ndims(a.data)
      error('Index exceed data set dimensions')
   end
   for j=1:ndims(a.data)
      if j > size(index(1).subs,2)
         index(1).subs{j}=1:size(a.data,j);
      end
      if isa(index(1).subs{j},'char')
         if strcmp(index(1).subs{j},':')
            index(1).subs{j} = 1:size(a.data,j);
         end
      end
      if length(index(1).subs{j}) ~= size(Val,j) & ~isempty(Val)
         error('Unequal dimensions on the two sides of the assignment')
      end
   end
   if isempty(Val)
      DimEm = cellfun('length',index(1).subs) == size(a);
      if sum(DimEm) == ndims(a)
         a = [];
         return
      elseif sum(DimEm) == ndims(a)-1
         a.content = subsasgn(a.content,index(1),Val);
         [index(1).subs{find(DimEm)}] = deal(':');
      else
         error('A null assignment can have only one non colon index')
      end
      a.data(index(1).subs{:}) = [];
      
   elseif isa(Val,'double')
      Sa = size(a.data);
      Labels{1} = label(Sa(1) + 1:Sa(1) + size(Val,1),'Sam.');
      for i = 2:ndims(a.data)
         Labels{i} = label(Sa(i) + 1:Sa(i) + size(Val,i));
      end
      a.content = subsasgn(a.content,index,Content(Labels));
      a.data(index(1).subs{:}) = Val;
      
   elseif isa(Val,'cbdataset')
      a.content = subsasgn(a.content,index,Val.content);
      a.data(index(1).subs{:}) = Val.data;
      
   else
      error('Type mismatch error')
   end
   
otherwise 
   error('Type mismatch error')
end

if ~isempty(a)
   a.lastmod = fix(clock);
end
