function Labs = checklabels(Labs,DataDims)
% Check the correspondence between the provided labels and the cbdataset object dimensions
% If any of the elements of Labs is an empty array the labels are treated and filled in using 
% the default value: 'Sam. n' in the first mode and 'Var. n' in the others
%
%   Author: Giorgio Tomasi
%       Royal Agricolture University, MLI, LMT
%       1958 Frederiksberg C
%       Danmark
%       email: gt@kvl.dk
%
if length(Labs) ~= length(DataDims) | ~iscell(Labs)
   error('Inadequate value for ''labels'' property')
   return
end
ClassLabs                                 = 2 * cellfun('isclass',Labs(:),'char') + ...
   								            3 * cellfun('isclass',Labs(:),'cell') + ...
                                            4 * cellfun('isclass',Labs(:),'label') + ...
                                            5 * cellfun('isclass',Labs(:),'double');
ClassLabs(cellfun('length',Labs(:)) == 0) = 1;
if any(ClassLabs == 0)
   error('Inadequate value for ''labels'' property');
end
if all(ClassLabs == 4)
   return
end
if all(ClassLabs == 1)
   error('All the labels are empty')
else
   t = find(ClassLabs == 1);
   for i = 1:length(t)
      if t(i) == 1
         Labs{t(i)} = label(1:DataDims(t(i)),'Sam.');
      else
         Labs{t(i)} = 1:DataDims(t(i));
      end
   end
end
t = find(ClassLabs == 2);
for i = 1:length(t)
   Labs{t(i)}      = cellstr(Labs{t(i)});
   ClassLabs(t(i)) = 3;
end
t = find(ClassLabs == 3);
for i = 1:length(t)
   if ~all(cellfun('isclass',Labs{t(i)},'char')) 
      error('Inadequate value for ''labels'' property')
   end
end
for i = 1:length(DataDims)
   Labs{i} = label(Labs{i});
   if length(Labs{i}) ~= DataDims(i)
      error(['Inconsistent labels length for mode ',num2str(i)])
   end
end

