function a = permute(b,Order)
% Operates as the builtin permute command, only on cbdataset objects
%
%   Author: Giorgio Tomasi
%       Royal Agricolture University, MLI, LMT
%       1958 Frederiksberg C
%       Danmark
%       email: gt@kvl.dk

if nargin < 1 
   error('Missing input parameters')
end
if nargin < 2
   Order = 1:ndims(b);
end
if length(Order) ~= ndims(b)
   error('length of ORDER is invalid.')
end
if any(sort(Order(:)) ~= [1:ndims(b)]')
   error('ORDER contains an invalid permutation index.')
end
b.data                   = permute(b.data,Order);
d                        = struct(dscontent(b));
b.Content.labels.reorder = d.labels(Order);
a                        = b; 
