function w = min(a,b,c)
% It operates as the normal min operator, only on cbdataset object
% the results are given as double arrays
%
%   Author: Giorgio Tomasi
%       Royal Agricolture University, MLI, LMT
%       1958 Frederiksberg C
%       Danmark
%       email: gt@kvl.dk
try 
   if nargin < 2
      b = [];
   end
   if nargin < 3
      c = [];
   end
   if length(a) == 1 & ~isa(a,'cbdataset')
      a = repmat(a,size(b));
   elseif length(b) == 1 & ~isa(b,'cbdataset')
      b = repmat(b,size(a));
   end
   a = cbdataset(a);
   b = cbdataset(b);
   if nargin == 1
      w = min(a.data);
   elseif nargin == 2
      w = min(a.data,b.data);
   elseif nargin == 3
      w = min(a.data,b.data,c);
   end
catch
   error(lasterr)
end