function c = gt(a,b)
%  Operator "greater than" (A > B) for cbdataset objects: returns a logical binary array as the builtin operator
%  The response array elements are set to 1 when the relation is true and 0 otherwise
%  It allows to compare single scalars to cbdataset object or two cbdataset objects of the same dimensions
%
%   Author: Giorgio Tomasi
%       Royal Agricolture University, MLI, LMT
%       1958 Frederiksberg C
%       Danmark
%       email: gt@kvl.dk
try 
   if length(a) == 1 & ~isa(a,'cbdataset')
      a = repmat(a,size(b));
   elseif length(b) == 1 & ~isa(b,'cbdataset')
      b = repmat(b,size(a));
   end
   a = cbdataset(a);
   b = cbdataset(b);
   c = gt(a.data,b.data);
catch
   error(lasterr)
end