function display(ds)
% Display the cbdataset object
%
%   Author: Giorgio Tomasi
%       Royal Agricolture University, MLI, LMT
%       1958 Frederiksberg C
%       Danmark
%       email: gt@kvl.dk

disp(' ')
display(ds.content)
w = '';
for i=3:-1:1
   a = num2str(ds.lastmod(i));
   if length(a)==1
      a = ['0',a];
   end
   if i<3
      a = ['/',a];
   end
   w = [w,a];
end
w=[w,', '];
for i=4:6
   a = num2str(ds.lastmod(i));
   if length(a)==1
      a=['0',a];
   end
   if i>4
      a=[':',a];
   end
   w=[w,a];
end
disp([' Last modified : ',w])
disp([' Userdata      : ','Yes' * ~isempty(ds.userdata) + 'No ' * isempty(ds.userdata)])
disp(' ')

