function c = cat(Dim,B,varargin)
%CAT Concatenate arrays.
%   CAT(DIM,A,B) concatenates the cbdatasets A and B along
%   the dimension DIM (DIM can only be 1 or 2)  
%   CAT(2,A,B) is the same as [A,B].
%   CAT(1,A,B) is the same as [A;B].
%   
%   It automatically checks for the labels.
%   i.e. if DIM == 1 the labels in all modes but the first must be the same
%        if DIM == 2 the labels in the first mode must be identical
%
%   Author: Giorgio Tomasi
%         Royal Agricolture University, MLI, LMT
%         1958 Frederiksberg C
%         Danmark
%         email: gt@kvl.dk



if isempty(varargin)
   c = B;
   return
end
if isempty(B)
   if length(varargin) > 1
      c = varargin(:)';
   else
      c = varargin{1};
   end
   return
end
if ~isa(varargin,'cell')
   varargin = {varargin};
end
if ~isa(B,'cell')
   B = {B};
end
varargin = [B,varargin(:)'];
Classes = cellfun('isclass',varargin,'double') + 2 * cellfun('isclass',varargin,'cbdataset');
Classes(cellfun('length',varargin) == 0) = 3;
varargin(Classes == 3)                   = [];
Classes(Classes == 3)                    = [];
if any(~Classes)
   error('Type mismatch error for the data sets to be concatenated')
end

if Dim == 2
   
   LabsPos = min(find(Classes == 2));
   RefLabs = varargin{LabsPos}.content.labels{1};
   for i = 1:length(varargin)
      if Classes(i) == 1
         varargin{i} = cbdataset(varargin{i},'labels',[{RefLabs} cell(1,ndims(varargin{i})-1)]);
      end
      if size(varargin{i},1) ~= length(RefLabs)
         error('Data sets must have the same number of samples')
      end
      if ~all(strcmp(RefLabs,varargin{i}.content.labels{1}))
         error('The objects (samples) labels do not correspond')
      end
   end
   [c{1:length(varargin)}] = deal(varargin{:});
   
elseif Dim == 1
   
   if isempty(varargin)
      c = B;
   elseif length(B) > 1
      error('Vertical concatenation is allowed only for data set containing one block')
   end
   LabsPos = min(find(Classes == 2));
   D = getfield(struct(dscontent(varargin{LabsPos})),'labels');
   for i = 1:length(varargin)
      if ndims(varargin{LabsPos}) ~= ndims(varargin{i})
         error('The dimensions are not consistent')
      end
      if Classes(i) == 1
         varargin{i} = cbdataset(varargin{i},'labels',D);
      end
   end
   for i = 2:ndims(varargin{LabsPos})
      RefLabs = varargin{LabsPos}.content.labels{i};
      for j = 1:length(varargin)
         if size(varargin{j},i) ~= length(RefLabs)
            error('Data sets'' dimensions do not match')
         end
         if ~all(strcmp(RefLabs,varargin{j}.content.labels{i}))
            error('The objects (samples) labels do not correspond')
         end
      end
   end
   [SamLabs,X,Desc,Scal] = deal([]);
   Pos                   = 0;
   for i = 1:nargin - 1
      SamLabs = [SamLabs;varargin{i}.content.labels{1}];
      Scal    = [Scal;varargin{i}.content.scalars{1}];
      X       = cat(1,X,varargin{i}.data);
      Desc    = [Desc;{['Rows ',sprintf('%i - %i',Pos + 1,Pos + size(varargin{i}.data,1))]};varargin{i}.content.description;{' '}];
      Pos     = Pos + size(varargin{i}.data,1);
   end
   SamLabs = label(SamLabs,varargin{1}.content.deflab{1},Scal,varargin{1}.content.axislabels{1},varargin{1}.content.modenames{1},varargin{1}.content.measunits{1});
   %if length(unique(SamLabs)) ~= length(SamLabs)
   %   SamLabs = label(1:length(SamLabs),'Sam.');
   %end
   c = cbdataset(X,'name',varargin{1}.content.name,'type',varargin{1}.content.type,'author',varargin{1}.content.author,...
      'labels',{SamLabs,D{2:end}},'description',Desc);
   
else
   error('Not available')
end
