/******************************************************************POLYS
** phimin.c                                                           **
**                                                                    **
** Molecular Energy Minimization                                      **
** ------------------                                                 **
** This module contains rutines for minimizing energy in dihedral     ** 
** space.                                                             **
**                                                                    **
** Written by Soren Balling Engelsen, INRA-93/94                      **
** Revisions: SBE (UCPH-97)                                           **
***********************************************************************/

#include <stdio.h>
#include <math.h>
#include "polys.h"
#include "extern.h"

/* Updates the vector of rotatable bonds - rotvec[] */
static void
new_rotmem(int bnr, int a, int b, int c, int d, int *pnr)
{
   static   BOOLEAN status = FALSE;
   static   int nsav = 0;         /* saves the bond number */
   static   double wsav = 0.0;    /* saves the weight priority */
   BOOLEAN  ring = FALSE;
   int      nrot, level;
   double   weight;

   if ((ring == TRUE) AND (nsav == bnr))
      return;
   /* discard bonds which are a part of a ring */
   nrot = FindConn(M.nat, M.nbond, b, c, &level);
   if (nrot == 0)
   {  ring = TRUE;
      return;
   }
   else
      ring = FALSE;

   /* calculate pseudo weight */
   weight=atomass(a)+atomass(b)+atomass(c)+atomass(d); 

   /* if new bond then reinitialize static variables */
   if (nsav != bnr)
   {  wsav = 0.0;
      nsav = bnr;
      if (status == TRUE)
         (*pnr)++;
   }

   /* take the heaviest torsion */
   if (weight >= wsav)
   {  RT[*pnr].from  = a;
      RT[*pnr].over1 = b;
      RT[*pnr].over2 = c;
      RT[*pnr].to    = d;
      RT[*pnr].fold  = nrot;
      wsav = weight;
      status = TRUE;
   }
}

/*
 * Generates a vector of rotatable bonds - rotvec[]. Only one
 * torsional angle will be choosen as a reference and preferably one
 * without terminal hydrogens. Torsions which are a part of a cyclic
 * structure will be discarded.
 */
void
gen_rotvec()
{
   register int bi;
   register int bj; 
   register int bk; 
   int      i, pno;
   double   phi;

   printf("Generating a vector of rotatable bonds\n\n");

   pno = 0;                                /* reset number of torsions */
   for ( bi=0; bi<M.nbond; bi++)            /* loop over central bond */
      /* discard bonds including single bonded atoms */
      if ((Valency(A[B[bi].from]) > 1) AND (Valency(A[B[bi].to]) > 1))
         /* connection backwards */
         for ( bj=0; bj<M.nbond; bj++)
            if (bj!=bi)                       /* not the same bond twice */
            {  /* CASE 1 */
               if (B[bj].from==B[bi].from) 
               {  /* connection forwards */
                  for ( bk=0; bk<M.nbond; bk++)
                     if ((bk!=bj) AND (bk!=bi))
                     {  if (B[bk].from==B[bi].to)
                           new_rotmem(bi, B[bj].to, B[bi].from, 
                                      B[bi].to, B[bk].to, &pno);
                        if (B[bk].to==B[bi].to)
                           new_rotmem(bi, B[bj].to, B[bi].from,
                                      B[bi].to, B[bk].from, &pno);
                     }
               } 
               /* CASE 2 */
               if (B[bj].to==B[bi].from)
               {  /* connection forwards */
                  for ( bk=0; bk<M.nbond; bk++)
                     if ((bk!=bj) AND (bk!=bi))
                     {  if (B[bk].from==B[bi].to)
                           new_rotmem(bi, B[bj].from, B[bi].from,
                                      B[bi].to, B[bk].to, &pno);
                        if (B[bk].to==B[bi].to)
                           new_rotmem(bi, B[bj].from, B[bi].from,
                                      B[bi].to, B[bk].from, &pno);
                     }
               }
            }

   M.nrot = pno+1;
   printf("  Number of rotatable bonds: %5d\n\n", M.nrot);
}

/* End of file */
