function t = tss(X,miss)
% Computes the total sum of squares of a vector/matrix/array. NaNs are ignored.
% 
% t = tss(X,miss)
%
% INPUTS
% X              : vector/matrix/array
% miss (Optional): 0 if no NaNs are present in the array (avoids the time necessary to
%                  scan the array for NaNs).
%
% OUTPUT
% t : total sum of squares of X.
%
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Denmark 
% 
% Last modified: 10-Jan-2005 15:39
% 
% Contact: Giorgio Tomasi, gt@kvl.dk, Rasmus Bro, rb@kvl.dk 
%

if nargin == 1 || (nargin == 2 && miss)
   X(isnan(X)) = 0;
end
t = norm(X(:))^2; 