function ShowDiagnostics(Options,F,SSX,dimX,OV)
% Display some parameters regarding a three-way array and the options used to fit a PARAFAC model to it.
% 
% ShowDiagnostics(Options,F,SSX,dimX,OV)
%
% Options: see ParOptions
% F      : model's rank
% SSX    : total sum of squares of the array X
% dimX   : size of the array X
% OV     : logical value (0 if no initial estimates are provided to the fitting algorithm)
%
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Denmark 
% 
% Last modified: 10-Jan-2005 15:42
% 
% Contact: Giorgio Tomasi, gt@kvl.dk, Rasmus Bro, rb@kvl.dk 
%

fprintf( '\n Compute PARAFAC model of a three-way array')
fprintf(['\n Array dimensions    : [ %i',sprintf(' x %i',dimX(2:end)),' ]'],dimX(1));
fprintf( '\n Rank of the model   : %i',F)
fprintf( '\n Algorithm           : %s',Options.algorithm)

fprintf( '\n\n Convergence criteria')
fprintf( '\n Max number of iterations        : %i',Options.convcrit.maxiter)
fprintf( '\n Relative loss function decrease : %1.1e',Options.convcrit.relfit)
fprintf( '\n Loss function value             : %1.1e',Options.convcrit.fit * SSX)
if any(strcmp({'dgn','pmf3'},lower(Options.algorithm)))
   fprintf( '\n Relative parameters'' update norm: %1.1e',Options.convcrit.par)
   fprintf( '\n Gradient infinite norm          : %1.1e',Options.convcrit.grad)
end

fprintf( '\n\n Initialisation')
if OV
    fprintf('\n Using old values for initialisation')
else
    
    switch(Options.initialisation.method)
        case 'random'
            fprintf('\n Matrices of random numbers as initialisation')
        case 'orth'
            fprintf('\n Column-wise orthogonal matrices of random numbers as initialisation')
        case 'svd'
            fprintf('\n Using SVD and projection for initialisation')
        case 'dtld'
            fprintf('\n Using DTLD for initialisation')
        case 'best'
            fprintf('\n Using the best of several initialisation')
    end
    
end
return
