function [varargout] = scale_factors(varargin)
% Scale matrices A, B, C, etc with identical n. of columns according to a specific convention.
%
% [As,Bs,Cs,...Zs] = Scale_factors (flag,A,B,C,...Z);
% 
% INPUTS: 
% flag (optional): if 0 (default) -> norm(As(:,f)) = norm(Bs(:,f)) = norm(Cs(:,f)) = ... = norm(Zs(:,f))
%                  if 1           -> norm(As(:,f)) = norm(Bs(:,f)) = ... = 1 and
%                                    norm(Zs(:,f)) = norm(A(:,f)) * norm(B(:,f) * ... * norm(Z(:,f))
% A,B,C,...Z     : loading matrices to be scaled
% 
% Outputs:
% As,Bs,Cs,...Z  : scaled loading matrices.
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Denmark 
% 
% Last modified: 10-Jan-2005 15:39
% 
% Contact: Giorgio Tomasi, gt@kvl.dk, Rasmus Bro, rb@kvl.dk 
%

if islogical(varargin{1}) | prod(size(varargin{1})) == 1;
   flag     = varargin{1};
   varargin = varargin(2:end);
else
   flag = false;
end
if nargout ~= length(varargin)
    error('The number of outputs should match the number of inputs.')
end
for i = 1:nargout - double(flag)
   sc(i,:)      = sqrt(sum(varargin{i}.^2));        % Compute column norms
   varargout{i} = varargin{i} * diag(sc(i,:))^-1;   % Normalise columns
end
if flag
   varargout{nargout} = varargin{end} * diag(prod(sc,1)); % Norm is "moved" to the last matrix
else
   
   sc  = diag(prod(abs(sc),1).^(1/length(varargin)));
   for i = 1:nargout
      varargout{i} = varargout{i} * sc;
   end

end
