function varargout = FacPerm(Perm,varargin)
% function [ap,bp,cp,...] = FacPerm (Perm,a,b,c,...);
% 
% Description:
% Permute columns of a, b, c, ... according to Perm
% 
% Inputs: 
% Perm        : permutation matrix or vector 
% a,b,c,...   : matrices whose columns are to be permuted according to Perm
% 
% Outputs:
% ap,bp,cp,...: matrices with permuted columns
% 
% Author: 
% Giorgio Tomasi 
% Royal Agricultural and Veterinary University 
% Rolighedsvej 30 
% DK-1958 Frederiksberg C 
% Danmark 
% 
% Last modified: 10-Jan-2005 15:23
%
% Contact: Giorgio Tomasi, gt@kvl.dk, Rasmus Bro, rb@kvl.dk 
%
if size(Perm,1) == size(Perm,2)
   for i=1:nargin-1
      varargout{i} = varargin{i} * Perm;
   end
elseif length(Perm) == prod(size(Perm));
   for i=1:nargin-1
      varargout{i} = varargin{i}(:,Perm);
   end
end
