function [X,F,Options,Factors] = Check_GenParafac_Input(X,F,Options,varargin);
% Check inputs for PARAFAC fitting algorithms
%
% Author: Giorgio Tomasi 
%         Royal Agricultural and Veterinary University 
%         Rolighedsvej 30 
%         DK-1958 Frederiksberg C 
%         Denmark 
% 
% Last modified: 10-Jan-2005 15:22
% 
% Contact: Giorgio Tomasi, gt@kvl.dk; Rasmus Bro, rb@kvl.dk 
%

% Data array
if ndims(X) ~= 3                                            % Stop if array is not three-way
    error('This implementation handles only 3-way arrays')
end
if any(isnan(X(:)))                                         % Stop if the data array contains missing values
    error('This implementation cannot handle missing values')
end

% Rank
if ~exist('F','var') 
    F = [];
end
if isempty(F) & nargin < 6                           % Ask for model's rank if not specified
    
    fprintf('\n Model''s rank is not specified\n\n')
    F = input('Specify the model''s rank (0 to exit): ');
    if ~F
        [F,Options,Factors] = deal([]);
        return
    end
    
end
if floor(F) ~= F
    error('Model''s rank must be an integer')
end

% Options
if ~exist('Options','var') 
    Options = [];
end
if isempty(Options)
    Options = ParOptions;
end
Options = ParOptions(Options); % Check Options
% Check file existence
if strcmpi(Options.compress,'on')
    if ~exist('Tucker.m','file')
        error('Compression cannot be used: Tucker.m (N-way toolbox) is not on the path')
    end
    if ~exist('PARAFAC.m','file')
        error('Compression cannot be used: PARAFAC.m (N-way toolbox) is not on the path and the refining step is not available.')
    end
end
if strcmpi(Options.algorithm,'als') && ~exist('PARAFAC.m','file')
   error('PARAFAC-ALS cannot be used: PARAFAC.m (N-way toolbox) is not on the path.')
end

%Check for initial values and number of factors and initialise
Factors = {};
if ~isempty(varargin)
    
    Factors = varargin;
    if ~isequal(size(X),cellfun('size',Factors,1))
        error('Initial values matrices not consistent with array dimensions')
    end
    if ~isempty(F) 
        if ~all(cellfun('size',varargin,2) == F)
            error('Initial values matrices inconsistent with the specified model''s rank')
        end
    else
        F = size(varargin{1},2);
    end
    
end
